# Authored by: John Welsh
# Created on: 5/11/20
# Update on: 5/14/20

# Desolation Wilderness: Search Cursor 2 - Lake Zone Number and Zone Name
print ("\nDesolation Wilderness: Search Cursor 2 - Lake Zone Number and Zone Name")

import arcpy, sys, os, traceback

# Workspace
arcpy.env.workspace = "C:\\Users\John\Documents\ArcGIS\Projects\DesolationWilderness\DesolationWilderness.gdb"
print ("\nWorkspace Set\n")

# Variables
lake_fc = 'Lakes'
print ("Variable Set\n")

try:

    # set a variable to point to the query
    query = """"Lake_Name" = 'Lake Zitella'"""

    # set a variable to point to the list of fields that only
    # includes Lake_Name and ZoneNumber_ZoneName
    field_list = ["Lake_Name", "ZoneNumber_ZoneName"]

    # Search Cursor - get a collection of rows from the feature class
    with arcpy.da.SearchCursor(lake_fc, field_list, query) as srows:
        for srow in srows:      # for each row in the cursor

            # assign a variable for the value for Lake_Name
            # assign a variable for the value for ZoneNumber_ZoneName
            lake_name = srow[0]
            zonenumber_zonename = srow[1]

            # print the value of the variables
            print (lake_name + ' ' + zonenumber_zonename)   


except:

    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n" + str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # prints error messages in the Progress dialog box
    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    # prints messages to the Python Shell
    print (msgs)
    print (pymsg)

    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))
