# A Comparison Map of Air Pollution During COVID-19 Situation of Bangkok, Thailand
 
# Created by:  Palika Wannawilai
# Created on:  08.05.2020
# Updated on:  13.05.2020


# Because the script will use the mapping Module, it must be imported

import arcpy, sys, traceback, datetime
from arcpy.mapping import *

arcpy.env.workspace = "C:\\Users\\Palika Wannawilai\\GEOG375\\Final Project\\Data\\Input_Data\\Final_Project_Input.gdb"

outpath = "C:\\Users\\Palika Wannawilai\\GEOG375\\Final Project\\Data\\Output_Data\\Final Project\\Final_Project_Output.gdb"

datapath = "C:\\Users\\Palika Wannawilai\\GEOG375\\Final Project\\Data\\Output_Data\\Final Project\\" 


Bagkok_fc = "Thailand"
out_BKK_feature = os.path.join (outpath, Bagkok_fc)

Bagkok_join_fc = "Thailand"
out_BKK_join_fc = os.path.join (outpath, Bagkok_join_fc)


BKK_air_table = "BKK_PM25_table"
out_air_table = os.path.join (outpath, BKK_air_table)


Bangkok_fl = "Bangkok_fl"
BKK_joined_fl = "BKK_joint_fl"

air_table = "BKK_airpollution"
air_tv = "air_tv"

BKK_join_ly = "BKK_join_ly"
out_BKK_query = datapath + "out_BKK_query"




try:

    # Create a new standalone table for air pollution report of Bangkok

    if  arcpy.Exists(out_air_table):
        arcpy.Delete_management(out_air_table)

    arcpy.CreateTable_management(outpath, BKK_air_table)


    # Create the AddField routines
    # Create the field that will be important for recording
    # Make sure that each field will have data type correctly

    arcpy.AddField_management(out_air_table, 'AP_NAME', 'TEXT', '', '', 50)
    arcpy.AddField_management(out_air_table, 'AP_IDN', 'SHORT')
    arcpy.AddField_management(out_air_table, 'PV_NAME', 'TEXT', '', '', 50)
    arcpy.AddField_management(out_air_table, 'Shape_Length', 'DOUBLE')
    arcpy.AddField_management(out_air_table, 'Shape_Area', 'DOUBLE')
    arcpy.AddField_management(out_air_table, 'ST_ID', 'TEXT', '', '', 50)
    arcpy.AddField_management(out_air_table, 'ST_Name', 'TEXT', '', '', 70)
    arcpy.AddField_management(out_air_table, 'PM25_March', 'SHORT')
    arcpy.AddField_management(out_air_table, 'PM25_Feb', 'SHORT')
    arcpy.AddField_management(out_air_table, 'ST_Area', 'TEXT', '', '', 70)
    arcpy.AddField_management(out_air_table, 'PV', 'TEXT', '', '', 50)
    arcpy.AddField_management(out_air_table, 'DISTRICT', 'TEXT', '', '', 70)
    arcpy.AddField_management(out_air_table, 'DIST_IDN', 'SHORT')
    arcpy.AddField_management(out_air_table, 'Latitude', 'DOUBLE')
    arcpy.AddField_management(out_air_table, 'Longtitude', 'DOUBLE')

    # Create a list of these fields
    
    aList = ['AP_NAME', 'AP_IDN', 'PV_NAME', 'Shape_Length', 'Shape_Area', 'ST_ID', \
             'ST_Name', 'PM25_March', 'PM25_Feb', 'ST_Area', 'PV', 'DISTRICT', 'DIST_IDN', 'Latitude', 'Longtitude']

    # Create List indexs for Bagkok_fc and air_table

    indexes = arcpy.ListIndexes(Bagkok_fc)

    for index in indexes:

        if (index.name == 'AP_Index'):  
            arcpy.RemoveIndex_management(Bagkok_fc, 'AP_Index')
            
    indexes = arcpy.ListIndexes(air_table)

    for index in indexes:

        if (index.name == 'DIST_Index'):
            arcpy.RemoveIndex_management(air_table, 'DIST_Index')
            
    arcpy.AddIndex_management(Bagkok_fc, 'FIRST_AP_IDN', 'AP_Index', 'NON_UNIQUE', 'NON_ASCENDING')
    arcpy.AddIndex_management(air_table, 'DIST_IDN', 'DIST_Index', 'NON_UNIQUE', 'NON_ASCENDING')

    
    # Create feature feature layers and table view

    if arcpy.Exists(Bangkok_fl):
        arcpy.Delete_management(Bangkok_fl)

    if arcpy.Exists(air_tv):
        arcpy.Delete_management(air_tv)

    arcpy.MakeFeatureLayer_management(Bagkok_fc, Bangkok_fl)

    arcpy.MakeTableView_management(air_table, air_tv)

    # Sets up the data and performs the AddJoin routine
    # Use the field that has the same data from Bangkok layer and BKK_airpollution table

    arcpy.AddJoin_management(Bangkok_fl, "FIRST_AP_IDN", air_tv, "DIST_IDN", "KEEP_ALL")
    
    # Print out a list of fields

    fields = arcpy.ListFields(Bangkok_fl)

    for field in fields:
        print (field.name)

    # Create the Insert Cursor

    with arcpy.da.InsertCursor(out_air_table, aList) as irows:

        field_list = [Bagkok_fc + '.AP_EN', \
                  Bagkok_fc + '.FIRST_AP_IDN', \
                  Bagkok_fc + '.FIRST_PV_EN', \
                  Bagkok_fc + '.Shape_Length', \
                  Bagkok_fc + '.Shape_Area', \
                  air_table + '.ST_ID', \
                  air_table + '.ST_Name', \
                  air_table + '.PM25_March', \
                  air_table + '.PM25_Feb', \
                  air_table + '.ST_Area', \
                  air_table + '.PV', \
                  air_table + '.DIST', \
                  air_table + '.DIST_IDN', \
                  air_table + '.Latitude', \
                  air_table + '.Longtitude']
        
    # Create a query to only process the rows where FIRST_AP_IDN and DIST_IDN are the same

    query = Bagkok_fc + '.FIRST_AP_IDN = ' + air_table + '.DIST_IDN'

    # Create the Search Cursor

    with arcpy.da.SearchCursor(Bangkok_fl, field_list, query)  as srows:

        for srow in srows:

            AP_NAME = srow[0] #Bagkok_fc + '.AP_EN'
            AP_IDN = srow[1] #Bagkok_fc + '.FIRST_AP_IDN'
            PV_NAME = srow[2] #Bagkok_fc + '.FIRST_PV_EN'
            Shape_Length = srow[3] #Bagkok_fc + '.Shape_Length'
            Shape_Area = srow[4] #Bagkok_fc + '.Shape_Area'
            ST_ID = srow[5] #air_table + '.ST_ID'
            ST_Name = srow[6] #air_table + '.ST_Name'
            PM25_March = srow[7] #air_table + '.PM25_March'
            PM25_Feb = srow[8] #air_table + '.PM25_Feb'
            ST_Area = srow[9] #air_table + '.ST_Area'
            PV = srow[10] #air_table + '.PV'
            DISTRICT = srow[11] #air_table + '.DIST'
            DIST_IDN = srow[12] #air_table + '.DIST_IDN'
            Latitude = srow[13] #air_table + '.Latitude'
            Longtitude = srow[14] #air_table + '.Longtitude'

            
            print (Bagkok_fc + ' AP_EN is: ' + AP_NAME)
            print (Bagkok_fc + ' FIRST_AP_IDN is: ' + str(AP_IDN))
            print (Bagkok_fc + ' FIRST_PV_EN is: ' + PV_NAME)
            print (Bagkok_fc + ' Shape_Length is: ' + str(Shape_Length))
            print (Bagkok_fc + ' Shape_Area is: ' + str(Shape_Area))
            print (air_table + ' Station_ID is: ' + str(ST_ID))
            print (air_table + ' Station_Name is: ' + ST_Name)
            print (air_table + ' PM25_March is: ' + str(PM25_March))
            print (air_table + ' PM25_Feb is: ' + str(PM25_Feb))
            print (air_table + ' Station_Area is: ' + ST_Area)
            print (air_table + ' Province is: ' + PV)
            print (air_table + ' DIST is: ' + DISTRICT)
            print (air_table + ' DIST_IDN is: ' + str(DIST_IDN))
            print (air_table + ' Latitude is: ' + str(Latitude))
            print (air_table + ' Longtitude is: ' + str(Longtitude) + '\n')

            # Create Insert Routine

            irows.insertRow((AP_NAME, AP_IDN, PV_NAME, Shape_Length, Shape_Area, ST_ID, ST_Name, PM25_March, PM25_Feb, ST_Area, PV, DISTRICT, DIST_IDN, Latitude, Longtitude))    
                             
    # Check to see the output feature class exists.
            
    if arcpy.Exists(out_BKK_feature):
        arcpy.Delete_management(out_BKK_feature)

    # Create Copy Features routine

    arcpy.CopyFeatures_management(Bagkok_fc, out_BKK_feature )

     # remove the join
    
    arcpy.RemoveJoin_management(Bangkok_fl, air_table)
    
    print ("Copied selected features from " + Bagkok_fc + " to " + out_BKK_feature)
    
    del irows

    del srow, srows

    # Create Add Join to a new Bangkok layer to perform attributes table in its layer
    # To prepare the data for definitetion query
    
    if arcpy.Exists(BKK_joined_fl):
        arcpy.Delete_management(BKK_joined_fl)

    arcpy.MakeFeatureLayer_management (Bagkok_join_fc,  BKK_joined_fl)

    arcpy.AddJoin_management(BKK_joined_fl, "FIRST_AP_IDN", air_tv, "DIST_IDN", "KEEP_ALL")

    # Create definitetion query for presenting of Bangkok feature area
    # Set the appropricate variables for definition query 

    field = '"Thailand_1"'
    value = "'Bangkok'"
    
    # Concatenate query syntax
    
    queryStr = str(field) + "=" + str(value)

    # Specify the MXD project and dataframe and layer file

    mxd = MapDocument(datapath + 'Final_Project.mxd')
    df = arcpy.mapping.ListDataFrames(mxd, "Layers")[0]
    
    # Assign the existing definition query to Bangkok Joined Layer
    
    for lyr in arcpy.mapping.ListLayers(mxd, "", df):
        if lyr.supports("DEFINITIONQUERY"):
            lyr.definitionQuery = queryStr
            
    # Create Graduated Colors Symbology for Bangkok layer to compare PM2.5 Data
    # between February and March, 2020
    # To changes the value field and the number of classes, and saves the map document
            
        if lyr.symbologyType == "GRADUATED_COLORS":
            lyr.symbology.valueField = "BKK_airp_3" #PM25 data of March
            lyr.symbology.numClasses = 5
            lyr.symbology.classBreakValues = [25, 37, 50, 90, 100]
            lyr.symbology.classBreakLabels = ["0 to 25", "26 to 37", "37 to 50", "50 to 90", "90 to 100"]
            
        if lyr.symbologyType == "GRADUATED_COLORS":
            lyr.symbology.valueField = "BKK_airp_4" #PM25 data of February
            lyr.symbology.numClasses = 5
            lyr.symbology.classBreakValues = [25, 37, 50, 90, 100]
            lyr.symbology.classBreakLabels = ["0 to 25", "26 to 37", "37 to 50", "50 to 90", "90 to 100"]

        arcpy.RefreshActiveView()
        
    mxd.save()

            
    
except:
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n" + str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))









