# Creating Zoop (Food) Denisty Maps - CalTrout Fish Food Project
#
# Created By: Seth Strumwasser
# Created on: 03.24.21
# Updated on: 05.12.21

print("Importing modules...")
import arcpy, sys, traceback, datetime
from os import listdir
from os.path import isfile, join
print("Modules imported.")

# variables
fd_folder = "D:\\seths_msi\\Documents\\CalTrout Mapping Projects\\Food_Density\\"
out_layer_folder = fd_folder + "output_layers\\"
out_layer = out_layer_folder + "RRSAC_sites_"
out_fc_folder = fd_folder + "output fcs\\"

# project and input layer
aprx = arcpy.mp.ArcGISProject(fd_folder + "Food_Density.aprx")
sites_layer_name = fd_folder + "RRSAC_sites.lyrx"

# csv variables
csv_loc = "D:\\seths_msi\\Documents\\CalTrout Mapping Projects\\Food_Density\\csv_s\\"
csv_list = [f for f in listdir(csv_loc) if isfile(join(csv_loc, f))]
csv_date = ''

# list of maps in project
maps = aprx.listMaps()

# layout variables
layout = aprx.listLayouts('Layout')[0]
map_frame = layout.listElements('MAPFRAME_ELEMENT')[0]
extent = map_frame.camera.getExtent()

# symbology layers
sites_symbo_lyr = fd_folder + "RRSAC_sites_symbo.lyrx"
sites_symbo_lyr_prop = fd_folder + "RRSAC_sites_symbo_proportion.lyrx"
symbo_folder = fd_folder + "symbology_layers\\"

# dictionary with discharge data
discharge_dict = {
    "022619": "7,013",
    "030619": "9,803",
    "031019": "7,217",
    "032019": "2,655",
    "032719": "2,821",
    "040319": "2,479",
    "040819": "1,787"
}

out_pdf = fd_folder + "Maps\\food_density_"
out_png = fd_folder + "Maps\\food_density_"

# remove 'Testing' map from map list
for m in maps:
    if m.name == 'Testing':
        maps.remove(m)
        print("Testing map removed.")

try:
    # iterate maps
    for m in maps:
        print ("...")

        # set map name variable
        map_name = m.name
        print ("Updating map: " + map_name)
        print ("...")

        # change basemap
        print("Updating basemap...")
        m.addBasemap("Imagery")

        # add pump house layer
        RR_file = arcpy.mp.LayerFile(fd_folder + "Rough_and_Ready_symbol.lyrx")
        m.addLayer(RR_file)

        # iterate through csv files and find the one that matches the map date
        print("Joining csvs...")
        for csv in csv_list:
            # create csv_date variable from file name
            csv_date = csv[0:6]
            # match the current map to the correct date
            if csv_date == map_name:
                # make feature layer from sites layer
                layer_fl = "RRSAC_sites_" + csv_date + "_fl"
                if arcpy.Exists(layer_fl):
                    arcpy.Delete_management(layer_fl)
                arcpy.MakeFeatureLayer_management(sites_layer_name, layer_fl)

                # join csv to the sites layer
                print("Joining " + csv)
                arcpy.AddJoin_management(layer_fl, 'Name', csv_loc + csv, 'Site')
                print("Join success.")

                # save to feature class
                print("Saving to feature class...")
                if arcpy.Exists(out_fc_folder + "RRSAC_sites_joined_" + csv_date + ".shp"):
                    arcpy.Delete_management(out_fc_folder + "RRSAC_sites_joined_" + csv_date + ".shp")
                arcpy.CopyFeatures_management(layer_fl, out_fc_folder + "RRSAC_sites_joined_" + csv_date + ".shp")
                print("Done.")

                # save generated features to output layer
                if arcpy.Exists(out_layer + csv_date + ".lyrx"):
                    arcpy.Delete_management(out_layer + csv_date + ".lyrx")
                arcpy.SaveToLayerFile_management(layer_fl, out_layer + csv_date + ".lyrx")
                break

        # add output FC to map
        m.addDataFromPath(out_fc_folder + "RRSAC_sites_joined_" + csv_date + ".shp")

        # apply correct symbology
        print("Applying symbology...")

        # get a list of layers so we can reference the complete layer
        layers = m.listLayers()
        for l in layers:
            print(l.name)
        complete_layer = layers[0]

        # apply symbology from symbology layer
        # symbology_fields = [["VALUE_FIELD", "040319__11", csv_date + "__11"]]
        symbo_layer = symbo_folder + "RRSAC_sites_" + csv_date + "_symbo.lyrx"
        arcpy.ApplySymbologyFromLayer_management(complete_layer, symbo_layer)

        # modify layout (keep this inside of map iteration)
        #
        # assigning correct map to map frame
        print("Assigning correct map to map frame...")
        map_frame.map = m

        # update map elements
        print("Updating map elements...")
        elements = layout.listElements()
        for e in elements:
            if e.name == 'title':
                e.text = 'Date: ' + map_name[0:2] + "/" + map_name[2:4] + "/" + map_name[4:6]
            if e.name == 'discharge':
                e.text = str(discharge_dict[csv_date])

        # set map frame extent
        print("Setting map frame extent...")
        map_frame.camera.setExtent(extent)

        # export map (PDF)
        print("Exporting to PDF...")
        if arcpy.Exists(out_pdf + map_name + ".pdf"):
            arcpy.Delete_management(out_pdf + map_name + ".pdf")
        layout.exportToPDF(out_pdf + map_name + ".pdf")

        # export map (PNG)
        if arcpy.Exists(out_png + map_name + ".png"):
            arcpy.Delete_management(out_png + map_name + ".png")
        layout.exportToPNG(out_png + map_name + ".png")

        # show that map is complete
        print("Map: " + csv_date + " complete!")

    print("Saving project for review")
    post_script_aprx = fd_folder + "Food_Density_postScript.aprx"
    if arcpy.Exists(post_script_aprx):
        arcpy.Delete_management(post_script_aprx)
    aprx.saveACopy(post_script_aprx)
    print("...")
    print("...Process complete!")

except:
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +  str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)

    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))

