##Buffer Select Tool

##The project I am proposing is a simple script that will automate a task I preform frequently. I am often tasked to create a series of buffers and selects of various distances and variables that changes from project to project.

##The tool will do the following:
##Upon executing the script, it will ask for two buffer distances and a point selection. Once these parameters are inputted, it will run two buffer routines on two separate features (lines). The script will then clip the buffers. The output of this clip will be the spatial component of a spatial select based on a third feature class (points). After this step an attribute selection will be preformed to get the final selection. The script will then export an excel/csv of the final selection.
##I am also going to attempt having the script auto email either the excel/csv or an email stating the file exists in X directory to the requester.


#import arcpy module

import arcpy, sys, traceback, os

#Create workspace

arcpy.env.workspace = 'C:\\Users\\s147386\\Desktop\\workSpace\\classTrainingExternal\\finalProjectProgramming\\pyFinal'
outpath = 'C:\\Users\\s147386\\Desktop\\workSpace\\classTrainingExternal\\finalProjectProgramming\\pyFinal'

#Create variable definitions for geoprocessing functions

highway = 'highway.shp'
footpath = 'footpath.shp'
animalSighting = 'animalSighting.shp'
outAnimals = 'animalSightingOut.shp'
report = 'report.csv'


sighting_layer = 'sighting'

hightwayBuffer = outpath + 'highwayBuffer.shp'
footpathBuffer = outpath + 'footpathBuffer.shp'
fullReport = outpath + 'report.csv'

hightwayBufferUnits = 'Feet'
footPathBufferUnits = 'Feet'



footPathHighwayClip = outpath + 'footPathHighwayClip.shp'

##Upon executing the script, it will ask for two buffer distances 


hightwayBufferValue = input('How far from the highway is the study area in feet?    ')


footpathBufferValue = input('How far from the footpath is the study area in feet?    ')

hightwayBufferDist = str(hightwayBufferValue) + ' ' + hightwayBufferUnits
footpathBufferDist = str(footpathBufferValue) + ' ' + footPathBufferUnits

##and a point selection. 


animalSightingType = input('Select: 1 for Frogs, 2 for Birds, 3 for Flowers    ')

##check to see if outputs existt
try:
    if arcpy.Exists(hightwayBuffer):
        arcpy.Delete_management(hightwayBuffer)
        
    if arcpy.Exists(footpathBuffer):
        arcpy.Delete_management(footpathBuffer)

    if arcpy.Exists(footPathHighwayClip):
        arcpy.Delete_management(footPathHighwayClip)

     

##Once these parameters are inputted, it will run two buffer routines on two separate features (lines). 

    arcpy.Buffer_analysis(highway, hightwayBuffer, hightwayBufferDist)
    
    arcpy.Buffer_analysis(footpath, footpathBuffer, footpathBufferDist)

##The script will then clip the buffers. 
    arcpy.Clip_analysis(hightwayBuffer, footpathBuffer, footPathHighwayClip)

##n attribute selection will be preformed to get the final selection.   
    if int(animalSightingType)== 1:
        query = """"type" = 'frogs'"""
    elif int(animalSightingType) == 2:
        query = """"type" = 'birdss'"""
    elif int(animalSightingType) == 3:
        query = """"type" = 'flowers'"""
    elif int(animalSightingType) > 3:
        query = """"""
    elif int(animalSightingType) < 0:
        query = """"""
 
    if arcpy.Exists(sighting_layer):
        arcpy.Delete_management(sighting_layer)
    
    arcpy.MakeFeatureLayer_management(animalSighting, sighting_layer)
    arcpy.SelectLayerByAttribute_management(sighting_layer, 'NEW_SELECTION', query)
   
##The output of this clip will be the spatial component of a spatial select based on a third feature class (points). 
##Select by location
    arcpy.SelectLayerByLocation_management(sighting_layer, 'INTERSECT', footPathHighwayClip, '', 'SUBSET_SELECTION')
 

##Copy data to new layer
    

    if arcpy.Exists(outAnimals):
        arcpy.Delete_management(outAnimals)    
    
    arcpy.CopyFeatures_management(sighting_layer, outAnimals)
    
## The script will then export an excel/csv of the final selection.
    if arcpy.Exists(report):
        arcpy.Delete_management(report)

    if os.path.exists(report):
        os.remove(report)
    
      
    if arcpy.Exists(fullReport):
        arcpy.Delete_management(report)

    arcpy.conversion.TableToTable(outAnimals, outpath, report)

    print ('Exporting Results')

        


##I am also going to attempt having the script auto email either the excel/csv or an email stating the file exists in X directory to the requester.



except:


    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +  str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))














