"""
Hawaii - Map Book Production

Vita Kovalyshyn
Created on:  05.13.2020
Updated on:  05.19.2020
"""

print ("Hawaii - a Series of Maps")

import arcpy, sys, traceback, datetime

author = "V. Kovalyshyn"

# reformat date to MM.DD.YYYY (search datetime module on python.org)

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

try:

    # Get the map document.(change the paths as needed)
    #datapath = 'C:\\PythonPrimer\\Chapter09\\'
    ppath = "C:\\Users\\vitak\\OneDrive\\Desktop\\Geog 375\\Final Project\\Kovalyshyn_Final_Project_GEOG_375\\"
    
    #mappath = datapath + "MyData\\Maps\\"    # output for PDFs
    mappath = "C:\\Users\\vitak\\OneDrive\\Desktop\\Geog 375\\Final Project\\"
    aprx = arcpy.mp.ArcGISProject(ppath + "Kovalyshyn_Final_Project_GEOG_375.aprx")
    # get a list of Maps that contain layers
    # [0] inicates the first (or only map from the map list, in this case)
    
    maplist = aprx.listMaps("Map") [0]  # the name of the Map tab is "Map"
    layout = aprx.listLayouts("Layout")[0]
    mapframe = layout.listElements("MAPFRAME_ELEMENT", "Map Frame")[0]

    #    Create variables for layout elements that are "text", "legend", and "mapsurround" elements.
    tElements = layout.listElements ("TEXT_ELEMENT")
    legend = layout.listElements("LEGEND_ELEMENT", "Legend")[0]
    scaleBar = layout.listElements ("MAPSURROUND_ELEMENT") [0]

    for tElement in tElements:
        #Indent to loop over elements
        #Use conditional statements
        if tElement.name == 'Title':
            tElement.text = 'Hawaii Lava Flow Hazard Zones'

        #      'Author' element's text property should be assigned to the
        #      Author variable defined at the top of the code

        if tElement.name == 'Subtitle':
                    tElement.text = 'Emergency Shelter Locations'

        if tElement.name == 'Author':
                tElement.text = author

        #      'Print Date' element's text property should be assigned to
        #      the CUR_DATE variable defined at the top of the code.

        if tElement.name == 'Date Printed':
                    tElement.text = str(CUR_DATE)

        if scaleBar.name == 'Scale Bar':
                    scaleBar.visible = True

        if legend.name == 'Legend':
             legend.visible = True

        #      Remember to use str() with this variable to cast the date
        #      to a string


    # Out-dented here, since the changes to the layout elements are complete

    #      Create a PDF of the map with the unique changes

    #      Add a check to see if the unique map name PDF file exists
    #      if it does, then delete it.

    if arcpy.Exists(mappath + 'lava_flow_hazard_zones_map.pdf'):
                arcpy.Delete_management(mappath + 'lava_flow_hazard_zones_map.pdf')

    #      Use the mappath variable and
    #      end with '(layer name)_map.pdf' string.

    #      Use the ExportToPDF routine to export the map

    #      Write a print statement that reports the map was printed


    layout.exportToPDF(mappath + 'lava_flow_hazard_zones_map.pdf')
    print ('Created ' + 'lava_flow_hazard_zones_map.pdf')

    # Map 2
    # get a list of layers
    TOCLayers = maplist.listLayers()

    for TOCLayer in TOCLayers:

        if TOCLayer.name == "Lava Flow Hazard Zones":
            #turn layer off
            TOCLayer.visible = False

        if TOCLayer.name == "Hillshade":
            #turn layer on
            TOCLayer.visible = True

        if tElement.name == 'Title':
             tElement.text = 'Hawaii Hillshade (Color)'

        if legend.name == 'Legend':
             legend.name = 'Hillshade'

    if arcpy.Exists(mappath + 'hillshade_map.pdf'):
            arcpy.Delete_management(mappath + 'hillshade_map.pdf')

    layout.exportToPDF(mappath + 'hillshade_map.pdf')
    print ('Created ' + 'hillshade_map.pdf')

    # Map 3
    TOCLayers = maplist.listLayers()

    for TOCLayer in TOCLayers:

        if TOCLayer.name == "Hillshade":
            #turn layer off
            TOCLayer.visible = False

        if TOCLayer.name == "2010 Population":
            #turn layer on
            TOCLayer.visible = True

        if tElement.name == 'Title':
             tElement.text = 'Hawaii Population (2010)'

    if arcpy.Exists(mappath + '2010_population_map.pdf'):
            arcpy.Delete_management(mappath + '2010_population_map.pdf')

    layout.exportToPDF(mappath + '2010_population_map.pdf')
    print ('Created ' + '2010_population_map.pdf')

        # Map 4
    for TOCLayer in maplist.listLayers():

        if TOCLayer.name == "Lava Flow Hazard Zones":
            query = """"vhzones_id" = '10' Or "vhzones_id" = '13'"""


            arcpy.SelectLayerByAttribute_management(TOCLayer, "NEW_SELECTION", query)

            result = arcpy.GetCount_management(TOCLayer)
            print ("Number of selected features:" + str(result))

            layer_extent = mapframe.getLayerExtent(TOCLayer)
            mapframe.camera.setExtent(layer_extent)


        if tElement.name == 'Title':
             tElement.text = 'Hawaii Population High Risk Areas'

        if legend.name == 'Legend':
             legend.visible = False

    if arcpy.Exists(mappath + '2010_population_high_risk_map.pdf'):
            arcpy.Delete_management(mappath + '2010_population_high_risk_map.pdf')

    layout.exportToPDF(mappath + '2010_population_high_risk_map.pdf')
    print ('Created ' + '2010_population_high_risk_map.pdf')

    # Clear any selected features
    for TOCLayer in maplist.listLayers():

        if TOCLayer.name == "Lava Flow Hazard Zones":
            arcpy.SelectLayerByAttribute_management(TOCLayer, "CLEAR_SELECTION")


    # Map 5
    TOCLayers = maplist.listLayers()

    for TOCLayer in TOCLayers:

        if TOCLayer.name == "2010 Population":
            #turn layer off
            TOCLayer.visible = False

        if TOCLayer.name == "Major Highways":
            #turn layer on
            TOCLayer.visible = True

        if TOCLayer.name == "Zoning Districts":
            #turn layer on
            TOCLayer.visible = True
    for TOCLayer in maplist.listLayers():

        if TOCLayer.name == "Lava Flow Hazard Zones":
            query = """"mzone" = '1' Or "mzone" = '2' Or "mzone" = '3' Or "mzone" = '4' Or "mzone" = '5'"""


            arcpy.SelectLayerByAttribute_management(TOCLayer, "NEW_SELECTION", query)

            result = arcpy.GetCount_management(TOCLayer)
            print ("Number of selected features:" + str(result))

            layer_extent = mapframe.getLayerExtent(TOCLayer)
            mapframe.camera.setExtent(layer_extent)

            if tElement.name == 'Title':
             tElement.text = 'Hawaii Zoning Districts'

    if arcpy.Exists(mappath + 'zoning_districts_map.pdf'):
        arcpy.Delete_management(mappath + 'zoning_districts_map.pdf')

    layout.exportToPDF(mappath + 'zoning_districts_map.pdf')
    print ('Created ' + 'zoning_districts_map.pdf')

    # Clear any selected features
    for TOCLayer in maplist.listLayers():

        if TOCLayer.name == "Lava Flow Hazard Zones":
            arcpy.SelectLayerByAttribute_management(TOCLayer, "CLEAR_SELECTION")
        
    print ('Completed Map Updates')

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    #https://pro.arcgis.com/en/pro-app/arcpy/get-started/error-handling-with-python.htm#GUID-67136187-389D-4627-93CB-C47DFE1E46F2
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +  str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))
