
# ---------------------------------------------------------------------------
# FinalProject_DaySpencer.py
# Created on: 2020-05-12 2:50:34.00000
#
# Description:
#   User Input data and values
#   Take in shapefiles/features classes loaded in active MXD file. Or from user inputed files and values.
#   -- runs Service Area Network Anlaysis allowing the user to add their own facility and roads network files.
#   -- runs Closest Facility Network Anlaysis allowing the user to add their own facility, incidents, and roads network files.
# ---------------------------------------------------------------------------
#By Spencer Day
# Import arcpy module
import arcpy   #uses the module that ArcGIS will use to run the analysis


# Local variables:
path = "E:\\ARC Programming GIS\\SpencerDay_FinalProject\\Project\\ProjectData.gdb\\" #path for file inputs/outputs saved to a Geodatabase 
##  feature class/shapefile variables
Road = "SacRoadNet"                 #name of Sacramento Roads network used for the Network analysis
Fac1 = "Fire_Stations"              #name of the first facilities which are Sacramento Fire Stations
Fac2 = "Hospitals"                  #name of the second facilities which are Sacramento Hospitals
Incid = "Schools"                   #name of the Incidents which are Sacramento Schools
#Network Parameters
Road = arcpy.GetParameter(0) #creates the parameter for the user to add the roads network of their choice 
Fac1 = arcpy.GetParameter(1) #creates the parameter for the user to add the first facilities in the analysis
Fac2 = arcpy.GetParameter(2) #creates the parameter for the user to add the second facilities in the analysis
Incid = arcpy.GetParameter(3) #creates the parameter for the user to add the incidents for the analysis
BreakValue = arcpy.GetParameter(4)#creates the parameter for the user to input the break values for the service area analysis
Units = arcpy.GetParameter(5) #creates the parameter for the user to add the units for analysis which can be distance or time
FindFac = arcpy.GetParameter(6) #creates the parameter for the user to add how many facilities they want to find in the closest facility analysis
path = arcpy.GetParameter(7) #path for file inputs/outputs saved to a Geodatabase 
    ##  input/output variables
    ### starter files

#User defined Input messages 
arcpy.AddMessage ("User Roads are " + str(Road)) #creates this message for the user to see what roads network they added. 
arcpy.AddMessage ("User Facility1 " + str(Fac1))    #creates this message for the user to see what first facilities they added. 
arcpy.AddMessage ("User Facility2 " + str(Fac2))   #creates this message for the user to see what second facilities they added. 
arcpy.AddMessage ("User Incidents " + str(Incid))   #creates this message for the user to see what incidents they added. 
arcpy.AddMessage ("User Break Value " + str(BreakValue))   ##creates this message for the user to see what break value they inputed.
arcpy.AddMessage ("User Break Units " + str(Units))   ##creates this message for the user to see what units they inputed.
arcpy.AddMessage ("User number of Facilities to find " + str(FindFac))   ##creates this message for the user to see how many facilities they want to find in the closest facility analysis.
#Output Locations
I1 = path + "Facility1_ServiceAreas.shp"      #output path and filename for the fire station service area or for the first facility they add
arcpy.AddMessage("I1 = " + I1)
I2 = path + "Facility2_ServiceAreas.shp"                             #output path and filename for the hospitals service area or for the second facility they add
arcpy.AddMessage("I2 = " + I2)
I3 = path + "Facility1_ClosestFacility.shp"             #output path and filename for the fire station closest facility or for the first facility they add
arcpy.AddMessage("I3 = " + I3)
I4 = path + "Facility2_ClosestFacility.shp"      #output path and filename for the hospital closest facility or for the second facility they add
arcpy.AddMessage("I4 = " + I4)
I5 = path + "Facility1"
I6 = path + "Facility2"

    
#Network Dataset
#networkDataset = Road
#arcpy.na.MakeNetworkDatasetLayer(Road, draw_elements=["EDGES","TURNS"])
#Service Area
arcpy.AddMessage("Processing Service Area 1 ")
try:
    arcpy.na.GenerateServiceAreas(out_Layer, BreakValue, Units, Road, I1) #Service area with the inputed files and values for the first facility
    arcpy.AddMessage("Processing Service Area 2 ")
    arcpy.na.GenerateServiceAreas(out_Layer2, BreakValue, Units, Road, I2) #Service area with the inputed files and values for the second facility
except:
     print arcpy.GetMessages()
    
#Closest Facilities
arcpy.AddMessage("Find Closest Facility: 1")
try:
    arcpy.na.FindClosestFacilities(Incid, out_Layer, Units, Road, path, "Routes", "Directions", I3, FindFac)    #Closest facility with the inputed files and values for the first facility
    arcpy.AddMessage("Find Closest Facility: 2")
    arcpy.na.FindClosestFacilities(Incid, out_Layer2, Units, Road, path, "Routes2", "Directions2", I4, FindFac) #Closest facility with the inputed files and values for the second facility
except:
     print arcpy.GetMessages()


