# General Layout "pseudo-code" for a typical geoprocessing script

# Created by:  Karen Cole
# Created on:  05.13.2021
# Updated on:  
# Copyright:   2011

'''
NOTES:  This section is reserved for general notes about the script

'''


# import the required modules for the python script
import arcpy, os, sys, traceback


# define common variables here

'''
Can include:

1. Workspaces
2. Directory or folder paths
3. Input/Ouput files, feature classes, tables, etc.
4. log file variables (e.g. print processing statements to a file)

'''
myFolder = "C:\\Users\\krcol\\Documents\\GEOG 375\\Assignments\\Final Project\\"
myWorkspace = os.path.join(myFolder, "Cole_GEOG375_F2021\\Cole_GEOG375_F2021.gdb")
myData = os.path.join(myFolder, "MyData")

arcpy.env.workspace = myWorkspace

#outpath = os.path.join(myFolder, "Cole_GEOG375_F2021\\Cole_GEOG375_F2021.gdb")

watershed = os.path.join(myData, "Cosumnes-Mokelumne-Calaveras_Watershed.shp")
watershed_fc = "Cosumnes_Mokelumne_Calaveras_Watershed"
ws_layer = os.path.join(myWorkspace, "Watershed")

raptors = os.path.join(myData, "Riparian_Area_Raptors.shp")
raptors_fc = "Riparian_Area_Raptors"
raptors_layer = os.path.join(myWorkspace, "Raptors")
raptors_clip = os.path.join(myFolder, "Raptors_Clip.shp")
rc_layer = os.path.join(myWorkspace, "Raptors_Clip")

counties_layer = os.path.join(myWorkspace, "Counties_Clip")
counties_clip = os.path.join(myFolder, "Mokelumne_Clip.shp")
cc_layer = os.path.join(myWorkspace, "Mokelumne_Clip")



try:


#-----------------------------------------------------------------------

#Loading layers...
    

    print(myWorkspace)
    print(watershed)
    print(watershed_fc)
    print(ws_layer)
    
    #Load watershed layer

    if arcpy.Exists(watershed_fc):
        arcpy.management.Delete(watershed_fc)

    arcpy.MakeFeatureLayer_management(watershed, watershed_fc)
    arcpy.MakeFeatureLayer_management(watershed_fc, ws_layer)

    print("""Watershed layer loaded: '""" + ws_layer + """'""")

    #Load raptors layer

    if arcpy.Exists(raptors_fc):
        arcpy.management.Delete(raptors_fc)

    arcpy.management.MakeFeatureLayer(raptors, raptors_fc)
    arcpy.management.MakeFeatureLayer(raptors_fc, raptors_layer)

    print("""Raptors layer loaded: '""" + raptors_layer + """'""")


#-----------------------------------------------------------------------

#Clipping layers...



    #Clip counties layer

    if arcpy.Exists(counties_clip):
        arcpy.management.Delete(counties_clip)

    arcpy.analysis.Clip(counties_layer, ws_layer, counties_clip)
    arcpy.management.MakeFeatureLayer(counties_clip, cc_layer)
    print("""Counties layer clipped: '""" + cc_layer + """'""")

    

    #Clip raptors layer

    if arcpy.Exists(raptors_clip):
        arcpy.management.Delete(raptors_clip)

    arcpy.analysis.Clip(raptors_layer, ws_layer, raptors_clip)
    arcpy.management.MakeFeatureLayer(raptors_clip, rc_layer)
    print("""Raptors layer clipped: '""" + rc_layer + """'""")


#-----------------------------------------------------------------------

#Setting up map production...



    # Pro project path
    ppath = "C:\\Users\\krcol\\Documents\\GEOG 375\\Assignments\\Final Project\\Cole_GEOG375_F2021\\"
    
    # output for PDFs.  Change as desired.
    
    mappath = myData
    
    # assign the pro project file to a variable
    aprx = arcpy.mp.ArcGISProject(ppath + "Cole_GEOG375_F2021.aprx")
    
    # get a list of Maps that contain layers
    # [0] inicates the first (or only map from the map list, in this case)
    
    maplist = aprx.listMaps("Map") [0]  # the name of the Map tab is "Map"
    layout = aprx.listLayouts("Layout")[0] # the name of the Layout tab is "Layout"

    # the name of the map frame in the layout is "Map Frame"
    mapframe = layout.listElements("MAPFRAME_ELEMENT", "Map Frame")[0] 


    # a list variable of the layout elements that are "text" elements
    tElements = layout.listElements("TEXT_ELEMENT")

    #Get a list of layers

    for TOCLayer in maplist.listLayers():

        print ("Layer Name " + str(TOCLayer.longName))

        if TOCLayer.longName == "Detail Map\\Watershed":
            layer_extent = mapframe.getLayerExtent(TOCLayer)
            mapframe.camera.setExtent(layer_extent)
            mapframe.camera.scale = mapframe.camera.scale * 1.1

    #Get a list of elements

    for tElement in tElements:

        if tElement.name == 'Map Title':
            tElement.text = 'Raptors Near Watershed'

        if tElement.name == 'Map Subtitle':
            tElement.text = 'Cosumnes Mokelumne Calaveras'





            
        

except:

    # https://pro.arcgis.com/en/pro-app/arcpy/get-started/error-handling-with-python.htm
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n" + str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))

