# Final Project
# Jacqueline Chapman
# 04.01.2021

'''


'''


import arcpy, datetime, os , sys, traceback

#VARIABLES

author = "J. Chapman"

arcpy.env.workspace = "E:\Spring 2021\Geog375\Final Project\data\\"
outpath = 'E:\Spring 2021\Geog375\Final Project\dataOUT\\'

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')



Amenity_Layer = "Park_Amenities_North_Natomas"



#########################################################################################################




try:
    #MAP VARIABLES
    
    #Project folder
    datapath = "E:\Spring 2021\Geog375\Chapman\\"
    
    # output for PDFs 
    mappath = "E:\Spring 2021\Geog375\Chapman\MapPDFs\\"
    
    #project file
    aprx = arcpy.mp.ArcGISProject(datapath + "Chapman.aprx")

    maplist = aprx.listMaps("Map")[0]

    #List of amenities that will be cycled through
    amenities_list = ["Dog Park", "Soccer Field","Basketball Court","Skate Park","Play Structure"]
    
    layout = aprx.listLayouts("Layout 1 2")[0]

    

    


    # get a list of layers
    for TOCLayer in maplist.listLayers():
       
        if TOCLayer.name == "Park_Amenities_North_Natomas":
            print ("inside TOC")
            Amenity_Layer = TOCLayer

    #for loop 
    for Amenity in amenities_list:

        query = """ "Amenity" = '""" + Amenity + """'"""
        print (query)
        Amenity_Layer.definitionQuery = query



        tElements = layout.listElements("TEXT_ELEMENT")

        #For loop to write amenities from list into map
        for tElement in tElements:

            if tElement.name == 'Title':
                
                tElement.text = Amenity + 's of North Natomas'
                tElement.elementPositionX = 2.7

            if tElement.name == 'Subtitle':
                
                    tElement.text = "Sacramento, California"
            #Write author name into map
            if tElement.name == 'Author':
                    tElement.text = author

            #Write current date into map
            if tElement.name == 'Date':
                    tElement.text = str(CUR_DATE)


        #Delete exisiting PDFs
            
        if arcpy.Exists(mappath + Amenity + '_map.pdf'):
            arcpy.Delete_management(mappath + Amenity + '_map.pdf')
                

        

    
                    

    #########################################################################################################



    

       # Export the maps to PDFs
        layout.exportToPDF(mappath + Amenity + '_map.pdf')
        print ('Created ' + Amenity + '_map.pdf')

        print("Exported " , Amenity , " map to PDF.")

    print ('Completed Unique Maps')

    

#########################################################################################################
except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))
