# Replace the onEnter function with this function below.

def onEnter(self):

        # user clicks the enter button, then this function fires
        
        # change this path as required

        datapath = r"C:\pythonprimer\chapter11\data\addresses.gdb"

        # this value can change depending on the name of the layer
        # in the table of contents
        addressLyr = "addresses"

        # get values of selected feature
        # (should be only 1 selected feature)

        # Repath the source to the MXD as required
        # gets the current MXD
        # no change required for this line
        self.mxd = arcpy.mapping.MapDocument("CURRENT")

        # get the layers in the MXD
        layers = arcpy.mapping.ListLayers(self.mxd)
        
        
        for layer in layers:
            print layer

            # if the "layer name" = the name of the address layer in the table of contents
            if layer.name == addressLyr:
                

                # create the search cursor (using 10.1 and later cursor format)
                                
                # list of fields used in the search and insert cursors
                fields = ['SHAPE@','STREETNUM', 'PREFIXDIR', 'PREFIX', 'STREETNAM', 'STREETTYPE', \
                          'SUFFIX', 'SUFFIXDIR', 'ZIPCODE', 'UNIT', 'UNIT_TYPE']

                # create the search cursor
                srows = arcpy.da.SearchCursor(layer, fields)                    

                # get the count of the number of rows in the search cursor (should be only 1)
                rowcount = int(arcpy.GetCount_management(layer).getOutput(0))

                # create the insert cursor (using 10.1 and later cursor format)
                
                # create an insert cursor (on the same layer)
                # since new addresses will be inserted into the existing addresses layer
                irows = arcpy.da.InsertCursor(layer, fields)

                print "Num rows in search cursor: " + str(rowcount)
                
                x = 1

                # do this only one time
                while x == 1:

                    # read values from the search cursor (this should only be 1 selected record)
                    # the cursor uses v 10.1 and later cursor format
                    # assign values to variables
                    
                    for srow in srows:
                        geom = srow[0] # SHAPE@ (the feature geometry (in this case point)
                        streetnum = srow[1] # STREETNUMBER
                        predir = srow[2] # PREFIXDIR
                        prefix = srow[3] # PREFIX
                        streetname = srow[4] # STREETNAME
                        streettype = srow[5] # STREETTYPE
                        suffix = srow[6] # SUFFIX
                        suffdir = srow[7] #SUFFIXDIR
                        zipcode = srow[8] # ZIPCODE

                        if srow[9] is None:  # the unit number may be "NULL"
                            unit = 0
                        else:
                            unit = srow[9] # UNIT
                        print str(unit)

                        unittype = srow[10] # UNIT_TYPE
                        

                        num_units = int(self.value) # value entered in the Addin
                        
                        print 'Name is: ' + streetname + ' ' + str(unit)
                        arcpy.AddMessage("Number of rows to add: " + str(num_units))

                        # counter, used in the while loop
                        cnt = 1

                        # variable to hold the "integer" value of unit variable (a string) above
                        uval = int(unit)
                        
                        while cnt <= num_units:
                            
                            # create/insert a new row (v. >= 10.1) in the address feature class
                            
                            irows.insertRow((geom, streetnum, predir, prefix, streetname, streettype, \
                                            suffix, suffdir, zipcode, str(uval + 1), unittype))

                            # update the unit value
                            uval += 1

                            # update the counter value to add multiple address "unit" points
                            cnt +=1

                        x+= 1 # increment x to stop the "while loop" on the search cursor

                        print "Inserted: " + str(num_units) + " rows."
                        arcpy.AddMessage("Inserted: " + str(num_units) + " rows.")
        
        # remove the cursor objects to prevent data locking
        del srow, srows, irows

        
        pass
