# Tasseled Cap Execution Function

# Created by: Nathan Jennings
# Created on: 08.29.2015
# Updated on: 08.29.2015
# Copyright: 2015
# www.urbandalespatial.com


# To be used in the execute routine for the image processing .pyt file
# used in Chapter 10, Demo 10b.

# Make sure the indendation for the function below matches the indentation
# levels of the other functions within the image processing.pyt file.

# Make sure the following two lines appear at the absolute top of the
# image processing.pyt file (and remove the "#" at the beginning of the lines)

# import arcpy, os
# from arcpy.sa import *

def execute(self, parameters, messages):
        """The source code of the tool."""
	

        # set overwrite output to True to overwrite intermediate and final output
        # if the files exist
	arcpy.env.overwriteOutput = True

        # split out the path and file to access the path for intermediate image files
	outpath, img = os.path.split(parameters[1].valueAsText)
	

	# Check out the Spatial Analysis Extension
	arcpy.CheckOutExtension("spatial")

	
	arcpy.AddMessage("Processing the image...")


        # the bright, green, and wet bands will always be overwritten
        # each time the script executes
	brightbnd = os.path.join(outpath, 'bright1.img')
        greenbnd = os.path.join(outpath, 'green1.img')
        wetbnd = os.path.join(outpath, 'wet1.img')

        # the "\\" is required to access a specific band (i.e. layer)
        in_image = parameters[0].valueAsText + "\\" # the input image    

        # the names of the "bands" in the file structure
        # this is standard naming for ArcGIS
        bands = ['Layer_1',
                 'Layer_2',
                 'Layer_3',
                 'Layer_4',
                 'Layer_5',
                 'Layer_6']

        tasseled_cap = parameters[1].valueAsText # the output image


        # Order of coefficients are TM1, TM2, TM3, TM4, TM5, TM7
        # where 1-7 are the Landsat TM band numbers

        bright = [0.2909, 
                  0.2493,  
                  0.4806,
                  0.5568,
                  0.4438,
                  0.1706]

        green = [-0.2728,
                 -0.2174,
                 -0.5508,
                 0.7221,
                 0.0733,
                 -0.1648]

        wet = [0.1466,
               0.1761,
               0.3322,
               0.3396,
               -0.6210,
               -0.4186]

        tc_bright = Float(Raster(in_image + bands[0]) * bright[0] + \
                    Raster(in_image + bands[1]) * bright[1] + \
                    Raster(in_image + bands[2]) * bright[2] + \
                    Raster(in_image + bands[3]) * bright[3] + \
                    Raster(in_image + bands[4]) * bright[4] + \
                    Raster(in_image + bands[5]) * bright[5])

        tc_bright.save(brightbnd)

        tc_green = Float(Raster(in_image + bands[0]) * green[0] + \
                    Raster(in_image + bands[1]) * green[1] + \
                    Raster(in_image + bands[2]) * green[2] + \
                    Raster(in_image + bands[3]) * green[3] + \
                    Raster(in_image + bands[4]) * green[4] + \
                    Raster(in_image + bands[5]) * green[5])

        tc_green.save(greenbnd)

        tc_wet = Float(Raster(in_image + bands[0]) * wet[0] + \
                    Raster(in_image + bands[1]) * wet[1] + \
                    Raster(in_image + bands[2]) * wet[2] + \
                    Raster(in_image + bands[3]) * wet[3] + \
                    Raster(in_image + bands[4]) * wet[4] + \
                    Raster(in_image + bands[5]) * wet[5])

        tc_wet.save(wetbnd)


        #Build the image using Composite Bands
        arcpy.CompositeBands_management(brightbnd + ';' + \
                                        greenbnd + ';' + \
                                        wetbnd, tasseled_cap)

	arcpy.AddMessage("Completed Tasseled Cap")

	# Check in the Spatial Analysis Extension for others to use
	arcpy.CheckInExtension("spatial")

        
        

        
        return
