# Chapter 10 - Clip and Buffer Tool

# Created by: Nathan Jennings
#             www.urbandalespatial.com
# Created on: 03.26.2011
# Updated on: 10.30.2011
# Copyright:  2011

'''
This script is the source for the Clip and Buffer Tool in the ACustomToolbox.
The arcpy.env.workspace and the outpath workspace and data path are not needed
since the tool interface will load the full path to the required feature classes.
Hence, they are commented out here.  Also note that the workspace and outpath
are not used in the body of the script.

The comments can be removed for futher testing.  The variables assigned to the
GetParameterAsText will need to be commented out if Python IDLE is used during
testing.

GetParameterAsText() is used to accept the user input from tool interfce.

AddMessage is used to create text messages that will show up in the tool progress
dialog box.  The print statements can remain in the code and used when running
the script from the command line or through a batch process.

'''

import arcpy, os, sys, traceback

# workspace (Not needed for the ArcGIS tool, Clip and Buffer
# The full path to the feature classes are provided as part of the parameter
# see below as well as in the tool interface.

# arcpy.env.workspace = 'C:\\PythonPrimer\\Chapter10\\Data\\'


# input feature class
# infile = 'City_Facilities.shp'

# infile = sys.argv[1]
infile = arcpy.GetParameterAsText(0)

# clip file
# clipfile = 'Central_City_CommPlan.shp'

# clipfile = sys.argv[2]
clipfile = arcpy.GetParameterAsText(1)


# output path
# Not needed since the full path to the output feature class are part of
# the output feature class parameters.  Seee below and the tool interface.

# outpath = 'C:\\PythonPrimer\\Chapter10\\MyData\\'


# output feature class
# outfile = outpath + 'City_Facilities_Clip.shp'

# outfile = sys.argv[3]
outfile = arcpy.GetParameterAsText(2)


# output buffer feature class
# outbuffer = outpath + 'City_Facilities_Buffer.shp'

# outbuffer = sys.argv[4]
outbuffer = arcpy.GetParameterAsText(3)

# buffer distance
# buff_val = 100

# buff_val = sys.argv[5]
buff_val = arcpy.GetParameterAsText(4)

# buffer units
# buff_units = 'Feet'

# buff_units = sys.argv[6]
buff_units= arcpy.GetParameterAsText(5) 

buff_dist = str(buff_val) + ' ' + buff_units


try:

    # check to see if feature class already exists
    # if it does, delete it
    if arcpy.Exists(outfile):
        arcpy.Delete_management(outfile)

    print 'Starting Clip routine'
    arcpy.AddMessage('Clipping ' + infile + ' with ' + clipfile + '.\n  Creating ' + outfile + '...')
    
    # Parameters using variables (Notice the indent because of the try statement)
    arcpy.Clip_analysis(infile, clipfile, outfile)

    print 'Finished Clip routine'
    arcpy.AddMessage('Finished Clipping ' + infile + ' with ' + clipfile + '...')
    arcpy.AddMessage('Created clip file: ' + outfile)
                     

    if arcpy.Exists(outbuffer):
        arcpy.Delete_management(outbuffer)

    print 'Starting Buffer routine'
    arcpy.AddMessage('Starting Buffer routine')
    arcpy.AddMessage('Buffering ' + outfile + ' by buffer distance ' + buff_dist + '...')

    arcpy.Buffer_analysis(outfile, outbuffer, buff_dist)

    print 'Created buffer file'
    arcpy.AddMessage('Created buffer file: ' + outbuffer)

    arcpy.AddMessage('Finished Clip and Buffer routine')
    


except:

    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    print arcpy.GetMessages(2)
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "arcpy ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
