# GEOG_375: Final Project
# Created by: Joseph Watkins
# Created on:  03.26.2018
# Updated on:  05.07.2018

'''
This script will produce a map and list of parcels
identified for acquisition by the Caltrans Division
of Right of Way for various road widening projects.

This script demonstrates:

1. Workspaces
2. Input and output feature classes
3. Use of ArGIS geoprocessing functions
4. Defining paraeters for the ArcGIS Clip routine programmatically
5. try: except: for error handling

'''
print 'GEOG 375 J.Watkins Final Project\n'

# Import arcpy module
import arcpy, os, sys, traceback
from arcpy.mapping import *

# Create workspace
arcpy.env.workspace = r"F:\\GEOG_375_Final\\MyData"

# Create variable definitions for geoprocessing functions
outpath = r"F:\\GEOG_375_Final\\NewData\\"
highways = "CA_State_Highways.shp"
county = "County_Boundaries.shp"
parcel = "Parcels.shp"
outhighway = outpath + "CA_State_Highways_Clip.shp"
outparcel = outpath + "Parcels_Clip.shp"
search_dist = "250 FEET"
sac_county_layer = "Sacramento"
route_layer = "CA_220"
parcel_impact = "parcel_impact"
outparcel_DBF = outpath + "impacted_parcels.dbf"
mxd = MapDocument("GEOG375_Final.mxd")



# Add try: block

try:

# Add county query routine

    print "Starting Sacramento County feature layer query"

    # check to see if the Sacramento feature layer exists; if so, delete it
    if arcpy.Exists(sac_county_layer):
        arcpy.Delete_management(sac_county_layer)

    # create the Sacramento County feature layer using a query
    query = """"CO" = 'SAC'"""

    # make the Sacramento County feature layer using the query parameter
    arcpy.MakeFeatureLayer_management(county, sac_county_layer, query)

    print "Finished Sacramento County feature layer query"


# Add Clip routine

    # check to see if clipped highway shapefile already exists; if it does, delete it
    if arcpy.Exists(outhighway):
        arcpy.Delete_management(outhighway)

    print "Starting Highway Clip to Sacramento County routine"
    
    # clip the statewide highway layer to the Sacramento County layer
    arcpy.Clip_analysis(highways, sac_county_layer, outhighway)

    print "Finished Highway Clip to Sacramento County routine"
    
    print "Starting CA 220 Route feature layer query"

# Add route query routine
    
    # check to see if the CA 220 Route feature layer exists; if so, delete it
    if arcpy.Exists(route_layer):
        arcpy.Delete_management(route_layer)

    # create the CA 220 Route feature layer using a query
    query2 = """"ROUTE" = '220'"""

    # make the CA 220 feature layer using the query parameter
    arcpy.MakeFeatureLayer_management(outhighway, route_layer, query2)

    print "Finished CA 220 Route feature layer query"

# Add parcel intersect routine

    print "Start Parcel, CA 220 Intersect Routine"

    # check to see if the impacted parcel layer exists; if so delete it
    if arcpy.Exists(parcel_impact):
            arcpy.Delete_management(parcel_impact)

            
    # make the impacted parcel feature layer using the query perameter
    arcpy.MakeFeatureLayer_management(parcel, parcel_impact)


    arcpy.SelectLayerByLocation_management(parcel_impact, "INTERSECT", \
                                           route_layer, search_dist, "NEW_SELECTION")

    
    print "Finished Parcel, CA 220 Intersect Routine"

# Create outparcel layer and outparcel DBF

    print "Copy Impacted Parcels"

    # copy impacted parcels to feature class
    if arcpy.Exists(outparcel):
        arcpy.Delete_management(outparcel)

    arcpy.CopyFeatures_management(parcel_impact, outparcel)

    # generate a database table of the impacted parcels

    if arcpy.Exists(outparcel_DBF):
        arcpy.Delete_management(outparcel_DBF)

    arcpy.CopyRows_management(outparcel, outparcel_DBF)

    print "Finished impacted parcels database table"

    # generate a .pdf of the impacted parcels

    #arcpy.mapping.ExportToPDF(outparcel_DBF, outpath + "impacted_parcels.pdf")

    #arcpy.mapping.ExportToPDF(GEOG375_Final.mxd, outpath + "parcel_map.pdf")

# Create a .PDF of the .MXD

    print "Save .mxd as .pdf"

    if arcpy.Exists(outpath + "GEOG375_Final.pdf"):
        arcpy.Delete_management(outpath + "GEOG375_Final.pdf")

    ExportToPDF(mxd, outpath + "GEOG375_Final.pdf")

    print "Finished saving .MXD as .PDF"


# Add except: block
except:

    # 6. Add exception code within except block
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    # Notice the indent because of the except block
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # prints error messages in the Progress dialog box
    arcpy.AddError(msgs)   
    arcpy.AddError(pymsg)

    # prints messages to the Python Shell
    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))

    print arcpy.GetMessages(1)
