
# Python 2.7.14   raster composite.py
# Produce a composite  raster from Landsat image by including a band filter on input directory,
# and provides a clip raster within the point of interest.
# Results are displayed in a map document for validation.
#
# Fred Ortiz
# April 2018

import arcpy, os, sys, traceback
from arcpy.mapping import *                                                       # eliminates writing: arcpy.mapping

# **** define local variables ****                                                ************ 
projectpath = 'Q:\\prj_New_Neighbors\\'                                           # project folder
inputraster = projectpath + "\data\imagery\landsat"                               # input folder location
arcpy.env.workspace = inputraster                                                 # list raster useage
outpath = projectpath + '\data\imagery\outrasters'                                # composite geodataset
outputfilename = '\landsat_jan_2014_compositebands.tif'
outputfilenameclip = '\landsat_jan_2014_compositebands_clip.tif'
mxd = MapDocument(outpath + '\SacRails.mxd')                                      # pre-existing map document - for validation
wild_card = "*band*.tif"
raster_type = 'tif'
##rectangle = ("-13525948.942202 4662162.975681 -13523801.844146 4663714.760103")   # Left Bottom Right Top - study area extent
poi = outpath + '\poi\study_area.shp'
# ********************************                                                ************

def ProcessRasterLayer(in_raster, out_rasterlayer):                               # --raster function header--
  rasterlayer = arcpy.MakeRasterLayer_management(in_raster, out_rasterlayer, "#", "#", "#")
  layer = rasterlayer.getOutput(0)
  arcpy.mapping.AddLayer(dataframe, layer, 'AUTO_ARRANGE')                        
  if out_rasterlayer == 'fullRaster':                                             # determine at time of call
    print '\n\tAdding full raster into map document'
  elif out_rasterlayer == 'clipRaster':
    print '\tAdding clip raster into map document'
  return rasterlayer

print '\nStarting Raster Composition Module...'
try:
  if arcpy.Exists(outpath + outputfilename):                                      # --previous file version check--
      files = os.listdir(outpath)
      print '\nRemoving previous folder files:  '
      for file in files:
          if file.startswith('landsat'):
              print '\t ' + file
              os.remove(outpath + '\\' + file)                                    #   delete directory raster contents

  print '\nValid input files:'                                                    # --valid input rasters by band--
  validrasters = arcpy.ListRasters(wild_card, raster_type)                        #   filter list - bands
  for validraster in validrasters:
      print '\t' + validraster
  print '\nCreating raster composition:'
  arcpy.CompositeBands_management(validrasters, outpath + outputfilename)
                                                                                  # --map document process--
  dataframe = ListDataFrames(mxd, "Layers")[0]                                    #   [0] ==> 1st dataframe
  tocLayers = ListLayers(mxd)                                                     #   list of layers
  for tocLayer in tocLayers:
    if tocLayer.name == 'fullRaster' or tocLayer.name == 'clipRaster':
      print '\tRemoving previous layer ==> ' + tocLayer.name
      RemoveLayer(dataframe , tocLayer)                                           #   delete layer

  rasterlayer = ProcessRasterLayer(outpath + outputfilename, 'fullRaster')        #   add full raster to mxd
  raster_clip = arcpy.Clip_management(rasterlayer, "#", outpath + outputfilenameclip, poi, "0", "ClippingGeometry")
  raster_clip.saveToFile(outpath + outputfilenameclip)
  ProcessRasterLayer(raster_clip, 'clipRaster')                                   #   add clip raster to mxd
  mxd.save()
                                                                                  # --process complete--
  print '\nCompleted raster composition process.\n'

except:                                                                           # --extracted via ARC Geog 375--
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)

finally:
    del mxd                                                                       # --release resource--
