
# Python 2.7.14   pdf_2_tiff.py
# This script converts geoPDF into TIFF format by traversing the input folder, and
# identifies the geoPDF files for the conversion process. Provides pyramids to improve
# the display performance of raster datasets.
#
# Fred Ortiz
# April 2018

import arcpy, os
                                                                                  # define variables
in_pdf = r'Q:\prj_New_Neighbors\data\imagery\geoPDF'                              # TIFF input folder
out_tiff = r'Q:\prj_New_Neighbors\data\imagery\TIFFs'                             # TIFF output folder
tiffcount = 0; xfile = 0                                                          # file counters

print '\nStarting PDF to TIFF Conversion.\n'

try:
  for (subdir, dirs, files) in os.walk(in_pdf):                                   # traversing directory
      for file in files:
          if file.endswith("geo.pdf"):                                            # identify files
              fname = (os.path.join(in_pdf, file))
              pdf = arcpy.mapping.PDFDocumentOpen(fname)                          # create PDFDocument object via inputs

              for page in range(1, pdf.pageCount+1):                              # loop through each page in the PDF
                 name = os.path.splitext(file)[0] + ".tif"                        # exclude original file extention
                 outTIFFpath = os.path.join(out_tiff, name)

                 if arcpy.Exists(outTIFFpath):                                    # test for prior document version
                   arcpy.Delete_management(outTIFFpath)

                 arcpy.PDFToTIFF_conversion(fname, outTIFFpath, '#', str(page), '#', 'NO_CLIP', 250, 'RGB_TRUE_COLOR', 'DEFLATE', '#')
                 tiffcount += 1
                 arcpy.BuildPyramidsandStatistics_management(out_tiff)            # generate pyramids and calculate statistics on each output TIFF
                 print "Exported " + outTIFFpath                                  # display feedback - can remove this line
          else:
              xfile += 1                                                          # other format

  pdfcount = len([x for x in os.listdir(in_pdf)]) - xfile
  if (pdfcount == tiffcount):                                                     # verify document production
      print '\n\tSucessful batch run - PDF conversion complete.\n'
  else:
      print '\nDocument production discrepancy.\n'
      print 'TIFF count# = ' + str(tiffcount)
      print 'PDF  count# = ' + str(pdfcount)

except:                                                                           # extracted via ARC Geog 375
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
   



