#Download Private Data from ArcGIS Online
#Levi Lebhart
#Geography 375 Python Programming for GIS
#Nate Jennings

#Modules
import os, sys, traceback
import tempfile
import zipfile, configparser
import json
import uuid
import urllib, urllib2
import getpass
import arcpy, arcrest, arcgis

#Variables input by the enduser
username = arcpy.GetParameterAsText(0)
password = arcpy.GetParameterAsText(1)
featureServiceName = arcpy.GetParameterAsText(2)
outpath = arcpy.GetParameterAsText(3)

#Operation to generate a secure token for session on the ArcGis Online Cloud, taken from 
def getToken(username, password=None, portal_URL = 'https://www.arcgis.com'):
    arcpy.AddMessage('\t-Getting Token...')
    #sets up the password and JSON parameters to be read for logging in
    if password == None:
        password = getpass.getpass()#prompts user if necessary
    #section describes what part of the JSON will be used  
    parameters = urllib.urlencode({
        'username': username,
        'password': password,
        'client': 'referer',
        'referer': portal_URL,
        'expiration': 60,
        'f': 'pjson'
    })
    #input generates the token needed
    tokenURL = '{0}/sharing/rest/generateToken?'.format(portal_URL)
    response = urllib.urlopen(tokenURL, parameters).read()
    #puts together the parameters and reads them to grab the unique token
    token = json.loads(response)['token']
    return token

#gets service definition to allow re-uploading of the file
def getFeatureServiceUrl(token, featureserviceURL):
    arcpy.AddMessage('t\-Login successful.')
    arcpy.AddMessage('t\-Retrieving service url...')
    #looks for the url within the JSON object
    featureserviceQueryParameters = urllibe.urlencode({
        "url" : ""
    })
    #reformats the JSON object into a simple url
    serviceURL = ''.format(featureserviceQueryParameters)
    #the url is then re-attached to the other end of the URL 
    grabUniqueUrl = '{0}&f=pjson&token={1}'.format(serviceURL, token)
    #gives the final url needed to get to the ID
    featureserviceURL = json.loads(grabUniqueUrl)
    return featureserviceURL

#gets the feature service's unique ID so it can be downloaded
def searchForGlobalId(featureserviceURL, token, featureFind):
    arcpy.AddMessage('t\-Service definition retreaved successfully...')
    arcpy.AddMessage('t\-Searching for unique item ID...')
    #pulls on the feature url and the token to show the JSON to pull the Global ID value out
    featureParameters = urllib.urlencode({ 
        "serviceItemId" : ""
    }),
    #opens up the URL and reads the ID and loads it into a temp
    featureFind = urllib2.urlopen(featureserviceURL, token, featureParameters).read()   
    serviceItemID = json.loads(featureFind)['serviceItemID']
    return serviceItemID

#downloads the service from the cloud using the Global ID
def downloadFeatureService(serviceItemID, username, password, outpath, featureService):
    arcpy.Add.Message('t\-Unique Service Item ID retrieved...')
    arcpy.Add.Message('t\-Begginging to download...')
    #uses the previous variables to establish connection to host and to begin downloading the feature service
    featureService = serviceItemID
    login = GIS(username, password)
    #uses id to direct straight to the file needed 
    featureServiceDL = login.content.get(seviceItemID)
    save_path = (outpath + featureService)
    if arcpy.Exists(save_path):
        arcpy.Delete_management(save_path)

        featureServiceDL.download(save_path)
        #pulls it down as a zip file and then extracts it to the defined outpath
        zf = ZipFile(outpath + featureService + '')    
        zf.extractall(path = outpath + featureService + '' + '')
                      

#optional set up to use with a config.ini for automated downloads of a certain service     
def Config(config, configmap, configfile):
    configfile = '\\automationUserConfig.ini'#userdefinedpath
    #sets up map to read the configuration file
    [USER_INFO]
    portal = http//www.arcgis.com
    username = USER_1
    password = PASS_1
    service_url = http//www.arcgis.com
    sde_conn = '\\connection.sde'#userdefinedpath
    config = ConfigParser.ConfigParser()
    #reads and uses the information from the file if available
    config.read(configfile)
    portal = config['USER_INFO']['portal']
    username = config['USER_INFO']['username']                               
    password = config['USER_INFO']['password']      
    service_url = config['USER_INFO']['service_url']
    sde_conn = config['USER_INFO']['sde_conn']

try:

except:
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)

#Code Sources:
#Get tokendef, modules, '{0}&f=pjson&token={1}' url trick, and formatting style from James Tedrick, SyncSurvey.py
                      #https://community.esri.com/groups/survey123/blog/2016/12/14/migrating-data-from-the-survey-feature-service-to-an-enterprise-geodatabase?commentID=45053&et=blogs.comment.created
#configparser set up used from mingrammer
    #https://gist.github.com/mingrammer/baa0242241ad86bf2ac174bc8b313ea6#file-using-external-file-config-ini-ini
    #https://gist.github.com/mingrammer/fe4440b750184ff658790ce0cb4d474c#file-using-external-file-py
#Except block from Nathan Jennings
#developer.arcgis.com for ArcRest and JSON navigation
                      #https://developers.arcgis.com/rest/
                      #https://developers.arcgis.com/python/
