# Introduction to Programming
# Final Project Script
# Created by:  Richard Gadberry
#              
# Created on: 04.01.2018
# Updated on: 04.25.2018
 
'''

# !!!! This script selects milk processing plants based on geographic and attribute \
criteria.  Criteria include location within milk producing counties and proximity to \
transportation infrastructure.  The script selects milk producing plants matching \
the chosen criteria and then identifies the nearest intermodal transit point to each plant. \
The script then joins the milk plant layer table and the intermodal facility table using a table \
join.  The script creates a new table to write output values.  A Search Cursor and an Insert Cursor \
are utilized to read fields from the joined table and write the values to the newly created Plants table!!!!

'''

print 'Selection and Distance Analysis - Milk Processing Plants'

import arcpy, sys, os, traceback

# set the current workspace 
arcpy.env.workspace = 'C:\\Intro_GIS_Program\\Final\\Program_Final.gdb\\'

out_path = 'C:\\Intro_GIS_Program\\Final\\Program_Final.gdb\\'

arcpy.env.overwriteOutput = True

arcpy.CheckOutExtension("spatial")

print "checked license"

# Variables
Counties = 'Counties'
County_Layer = 'Counties_Select'
Outpath_County = os.path.join(out_path, County_Layer)


Dairy_Plants = 'Dairy_Plants'
Dairy_Layer = 'Dairy_Layer'
Dairy_Select = 'Dairy_Select'
Dairy_Select_Layer = 'Dairy_Select_Layer'
Select_Buffer_Milk = 'Select_Buffer_Milk'
Select_Buff_Layer = 'Select_Buff_Layer'
Select_Buff_Path = os.path.join(out_path, Select_Buff_Layer)
Plants_Table = 'Plants_Table'
Outpath_Table = os.path.join(out_path, Plants_Table)

Out_Dairy = os.path.join(out_path, Dairy_Layer)
Out_Select = os.path.join(out_path, Dairy_Select)
Out_Select_Layer = os.path.join(out_path, Dairy_Select_Layer)


Intermodal_Shipment = 'Intermodal_Shipment'
Intermodal_Layer = 'Intermodal_Layer'
Inter_Path = os.path.join(out_path, Intermodal_Layer)
Search_Radius = "200000 Feet"
location = "LOCATION"
angle = "NO_ANGLE"


Truck_Routes = 'Truck_Routes' 
Truck_Layer = 'Truck_Layer'
Out_Truck = os.path.join(out_path, Truck_Layer) 
Truck_Buffer = 'Truck_Buffer'
Buffer_Dist = '10000 Feet'
Buffer_Layer = 'Buffer_Layer'
Out_Buffer = os.path.join(out_path, Buffer_Layer)


try:

    # Make County Feature Layer

    # !!!! first check to see if the county layer exists !!!!
    # !!!! if so, delete it !!!!

    if arcpy.Exists(Outpath_County):
        arcpy.Delete_management(Outpath_County)
    
    #Create County Feature Layer with query
    #Selecting for identified milk producing counties    

    query = """"COUNTY_ABBREV" = 'FRE' OR "COUNTY_ABBREV" = 'KIN' \
    OR "COUNTY_ABBREV" = 'KER' OR "COUNTY_ABBREV" = 'TUL' OR "COUNTY_ABBREV" = 'STA'"""    
 
    arcpy.MakeFeatureLayer_management(Counties, County_Layer, query)

    print "Created Feature Layer of Selected Milk Producing Counties"
    
    # Make Dairy Processing Plants Feature Layer

    # !!!!  first check to see if the milk plant layer exists, if so delete it

    if arcpy.Exists(Out_Dairy):
        arcpy.Delete_management(Out_Dairy)

    query = """"Fluid_Milk" = 'X'"""
        
    arcpy.MakeFeatureLayer_management(Dairy_Plants, Dairy_Layer, query)  
    
    print "created milk processing plant layer with query to select only plants processing fluid milk"

    #Select Dairy Processing Plants within Milk Producing Counties

    arcpy.SelectLayerByLocation_management(Dairy_Layer, "WITHIN", County_Layer, "", "NEW_SELECTION")

    print "selected dairy plants within select counties"

    result = arcpy.GetCount_management(Dairy_Layer)

    print str(result) + ' milk plants selected'
    
    # Copy Selected Plants to a new Feature Class
    
    if arcpy.Exists(Out_Select):
        arcpy.Delete_management(Out_Select)
    
    arcpy.CopyFeatures_management(Dairy_Layer, Dairy_Select)

    print "Copied Selected Features from " + Dairy_Layer + " to " + Dairy_Select

    # Generate a buffer for Trucking Routes

    #Check to see if the Trucking Routes Layer exists.

    if arcpy.Exists(Out_Truck):
        arcpy.Delete_management(Out_Truck)

    # Create Truck Route Layer

    arcpy.MakeFeatureLayer_management(Truck_Routes, Truck_Layer)

    print 'Created Truck Route Layer'
    
    # Create a buffer of the Truck Route Layer

    arcpy.Buffer_analysis(Truck_Layer, Truck_Buffer, \
                              Buffer_Dist, 'FULL', '', 'NONE', '')

    print 'Created Buffer around Truck Route Layer'

    # Select Milk Processing Plants located within the Truck Routes Buffer

    # Check to see if Buffer Layer Exists

    if arcpy.Exists(Out_Buffer):
        arcpy.Delete_management(Out_Buffer)

    # Create Truck Route Buffer Layer

    arcpy.MakeFeatureLayer_management(Truck_Buffer, Buffer_Layer)

    print 'Created Truck Route Buffer Layer'

    #Check to see if Layer of Selected Milk Plants Exists, if so delete it.  

    if arcpy.Exists(Out_Select_Layer):
        arcpy.Delete_management(Out_Select_Layer)

    arcpy.MakeFeatureLayer_management(Dairy_Select, Dairy_Select_Layer)

    print 'Created Feature Layer of Selected Milk Plants'
    
    # Select Milk Producing Plants located within the Truck Route Buffer
    #Create Layer of the Selected Dairy Plants Feature Class
    
    arcpy.SelectLayerByLocation_management(Dairy_Select_Layer, "WITHIN", Buffer_Layer, "", "NEW_SELECTION")

    print 'Selected Milk Plants within the buffer of Truck Routes'

    # Copy Selected Dairy Plants within the Buffer to a new Feature Class
    
    arcpy.CopyFeatures_management(Dairy_Select_Layer, Select_Buffer_Milk)

    print "Copied Features from the Dairy_Select_Layer to Select_Buf_Milk Feature Class"

    # Utilize the Near Tool to calculate distances between selected milk plants and intermodal transportation points

    # Create a Layer utilizing the Select_Buf_Milk
    # First Check to see if Milk Plants within Buffer Layer Exists

    if arcpy.Exists(Select_Buff_Path):
        arcpy.Delete_management(Select_Buff_Path)

    arcpy.MakeFeatureLayer_management(Select_Buffer_Milk, Select_Buff_Layer) 

    print "Created Layer of Selecteed Milk Plants within the Truck Routes Buffer Feature" 

    # Check to see if Intermodal Transit Point Layer Exists

    if arcpy.Exists(Inter_Path):
        arcpy.Delete_management(Inter_Path)

    arcpy.MakeFeatureLayer_management(Intermodal_Shipment, Intermodal_Layer)    

    print "Created Intermodal Transit Points Feature Layer"

    # Run Near Tool to calculate values for the distance Selected Milk Processing Plants
    # and Intermodal Shipping Points

    arcpy.Near_analysis(Select_Buff_Layer, Intermodal_Layer, Search_Radius, location, angle)

    print "Ran Near Analysis conmputing distances between nearest features in Select_Buff_Layer and Intermodal_Layer"

    # Create a new table to write Data from Select_Buff_Layer (milk plants) and Intermodal Shipment Points to
    # Use a join to join Intermodal Transit Points Attribute Table to Select_Buff_Milk Attribute Table which \
    # contains the the object ID of the nearest Intermodal Point.
    # The values for the Plant Name and the corresponding nearest Intermodal Point along with Distance will be \
    # written to a new table.  


    #Check to see if Plants_Table exists, if so delete it

    if arcpy.Exists(Outpath_Table):
        arcpy.Delete_management(Outpath_Table)

    #Create Table

    arcpy.CreateTable_management(out_path, Plants_Table)

    #Add Field to Plants_Table
    arcpy.AddField_management(Outpath_Table, 'Plant_Name', 'TEXT', '', '', 40)
    arcpy.AddField_management(Outpath_Table, 'Place_addr', 'TEXT', '', '', 80)
    arcpy.AddField_management(Outpath_Table, 'NEAR_DIST', 'FLOAT')
    arcpy.AddField_management(Outpath_Table, 'IF_NAME', 'TEXT', '', '', 40)
    arcpy.AddField_management(Outpath_Table, 'CITY', 'TEXT', '', '', 40)

    print "created Plants_Table feature table and added rows"
    
    #Add Table Join

    arcpy.AddJoin_management(Select_Buff_Layer, "NEAR_FID", Intermodal_Layer, "OBJECTID", "KEEP_COMMON")

    print "Completed Table Join between Select_Buff_Layer and Intermodal Transit Points Layer"

    #Utilize Insert Cursort to write data to Plants_Table

    fields_milk = arcpy.ListFields(Select_Buff_Layer)

    for field in fields_milk:
        print field.name

    fields = ['Plant_Name', 'Place_addr', 'NEAR_DIST', 'IF_NAME', 'CITY']

    with arcpy.da.InsertCursor(Outpath_Table, fields) as irows:

    #Use SearchCursor to read desired fields from the Select_Buff_Layer (selected milk plants within the truck route buffer)

        field_list = [Select_Buffer_Milk + '.Plant_Name', \
                      Select_Buffer_Milk + '.Place_addr', \
                      Select_Buffer_Milk + '.NEAR_DIST', \
                      Intermodal_Shipment + '.IF_NAME', \
                      Intermodal_Shipment + '.CITY']

        query = """"NEAR_FID" IS NOT NULL"""

        with arcpy.da.SearchCursor(Select_Buff_Layer, field_list, query) as srows:

            print "starting SearchCursor"
            for srow in srows:
                Plant_Name = srow[0]
                Place_addr = srow[1]
                NEAR_DIST = srow[2]
                IF_NAME = srow[3]
                CITY = srow[4]

                print "executing srows"

                print "printing variabless values"
                print Plant_Name
                print Place_addr
                print NEAR_DIST
                print IF_NAME
                print CITY 
                
                irows.insertRow((Plant_Name, Place_addr, NEAR_DIST, IF_NAME, CITY))

        print 'Wrote fields from joined tables to Outpath_Table'

    #Remove Join

    arcpy.RemoveJoin_management(Select_Buff_Layer, Intermodal_Layer)

    # Delete Cursors

    del srow, srows
    del irows

    print "removed join and deleted cursors" 

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n" + str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)

    
