# Final Project: Creating Map Books
# Created By: Chris Cretto
# Created On: 04/30/2018
# Updated On:



# 1. SETUP MOFULES AND GLOBAL VARIBLES
#   Import necessary modules.
#   Variable: author - set to my Agency Name.
#   Variable: CUR_DATE - standardize date format to be used as created date
#   Set Workspace - to my personal data folder to the file geodatabase
#       (notes to reference fgdb as well)
#   Variable: chg_shp - shapefile reference for my Search Cursor

import arcpy, sys, traceback, datetime
from arcpy.mapping import *

author = 'Tax Area Services Section'

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

arcpy.env.workspace = 'C:\\Users\\ccrettol\\Desktop\\Geog375\\FinalProject\\Data_co26\\'
    #arcpy.env.workspace = 'C:\\Users\\ccrettol\\Desktop\\Geog375\\FinalProject\\Data_co26\\TASS_GIS_co26.gdb\\'
    # * to reference a file gdb - part 1 of 2

chg_shp = 'TASS_Changes_co26.shp'
    #chg_shp = 'TASS_Changes_co26'
    # * to reference a file gdb - part 2 of 2

try:

    # 2. DETERMINE WHICH DETAIL NUMBERS THE DESIRED (2017) CHANGES ARE ON.
    #   Create query to search by year. Create a list of column headings.
    #   Use Search Cursor to query shapefile table. Loop through each row.
    #   Print from columns to determine which Detail numbers to make into
    #   mapbooks in future steps.

    print 'List of 2017 Boundary Changes:'

    query = """"YEAR" = '2017'"""

    field_list = ["CHG_NO", "NOTES"]

    with arcpy.da.SearchCursor(chg_shp, field_list, query) as srows:
        for srow in srows:
            filenumber = srow[0]
            notes = srow[1]

            print filenumber + ': ' + notes


    # 3. SETUP THE PATHS
    #   Paths to: data folder, map location, pdf output, and specific .mxd.
    #   Print some titles for reference.
    
    datapath = 'C:\\Users\\ccrettol\\Desktop\\Geog375\\FinalProject\\'
    mappath = datapath + 'Data_co26\\'
    pdfpath = datapath + 'Detail_Maps\\'
    co_mxd = MapDocument(datapath + 'co26.mxd')

    print '\n' + 'Map Title: ' + str(co_mxd.title)
    print 'Map Author: ' + author


    # 4. SELECT THE DATA FRAME FROM THE .MXD
    #   Print any relevant dataframe elements.
    
    dataframe = ListDataFrames(co_mxd, "Layers") [0]

    print 'Map Frame Map Units: ' + str(dataframe.mapUnits)

    # 5. GET A LIST OF THE TEXT ELEMENTS FROM THE .MXD,
    #   Call out all Text Elements. Loop through each element. 
        
    tElements = ListLayoutElements(co_mxd, "TEXT_ELEMENT")

    for tElement in tElements:

        # 6. SET GLOBAL NAMES
        #   Change generic titles to specific county, date, and author. 
        #   Modify positioning if necessary.

        if tElement.name == 'Map Title':
            tElement.text = 'Mono County'
    
        if tElement.name == 'Print Date':
            tElement.text = 'Last Updated: ' + str(CUR_DATE)
            tElement.elementPositionX = 8.05

        if tElement.name == 'Author':
            tElement.text = 'Created by: ' + author
            tElement.elementPositionX = 8.05

        if tElement.name == 'File Number':
            tElement.elementPostionX = 8.4
 

    # 7. GET A LIST OF LAYER FROM .MXDs TABLE OF CONTENTS, PRINT FOR REFERENCE.
    #   Get a list of layers from the .mxd. Loop through each layer.
    #   Print each layer name, as well as the long name to adjust properties.
    #   These names will help query specific changes in future steps.

    TOCLayers = ListLayers(co_mxd)

    print '\n' + 'Display layout elements for reference...'
    
    for TOCLayer in TOCLayers:
        print 'Layer Name: ' + str(TOCLayer.name)
        print 'Longname: ' + str(TOCLayer.longName) + '\n'


    # 9. SET GLOBAL LAYER PROPERTIES
    #   Modify layer visability and transparency if necessary.

        if TOCLayer == 'TASS_TRA_co26':
            TOCLayer.visibility = True

        if TOCLayer == 'TASS_Changes_co26':
            TOCLayer.visibility = True
            TOCLayer.transparency = 50

        if TOCLayer.longName == 'Map Elements\INDEX_co26':
            TOCLayer.visibility = True
            TOCLayer.showLabels = False
            
        if TOCLayer.longName == 'Map Elements\CoBdry_co26':
            TOCLayer.visibility = True

        if TOCLayer.longName == 'Map Elements\PARCEL2009_co26':
            TOCLayer.visibility = True
            TOCLayer.transparency = 20

        if TOCLayer.longName == 'Map Elements\Roads':
            TOCLayer.visibility = False

        if TOCLayer.longName == 'Map Elements\sections':
            TOCLayer.visibility = False

        ###CREATE THE FIRST DETAIL MAP###

        # 10. SEARCH FOR FIRST CHANGE, SELECT IT, ZOOM, MODIFY TEXT ELEMENTS
        #   Loop through each layer. Searcj for specific layer name.
        #   Query specific change. Zoom to that area. Create a buffer if
        #   necessary. Change text elements if necessary. Remove selection
        #   so it doesnt show on mapbook.
        
        for TOCLayer in TOCLayers:
            if TOCLayer.longName == 'TASS_Changes_co26':

                query = """"CHG_NO" = '2017-001'"""

                arcpy.SelectLayerByAttribute_management(TOCLayer, "NEW_SELECTION", query)

                dataframe.extent = TOCLayer.getSelectedExtent()
                dataframe.scale = dataframe.scale * 1.5
                #dataframe.zoomToSelectedFeatures()  #Can be used, displays different extent

                arcpy.SelectLayerByAttribute_management(TOCLayer, "CLEAR_SELECTION")


            # 11. EDIT MAP 1 TEXT ELEMENTS, PRINT STATUS
            #   Update the file number and detail number. Print 
        
                for tElement in tElements:
                    if tElement.name == 'File Number':
                        tElement.text = 'File: 17-001'

                    if tElement.name == 'Detail Number':
                        tElement.text = 'Det: 010'
        
    print 'Creating updated PDFs'
    print 'Exporting Map 1...'


    # 12. DELETE EXISTING .PDF, EXPORT NEW .PDF TO DESIRED FOLDER

    if arcpy.Exists(pdfpath + 'co26_Ch_17_001.pdf'):
        arcpy.Delete_management(pdfpath + 'co26_Ch_17_001.pdf')

    ExportToPDF(co_mxd, pdfpath + 'co26_Ch_17_001.pdf')

    print 'Complete'

    ###CREATE ADDITIONAL DETAIL MAPS###

    # 13. APPLY STEPS (10) AND (11) TO ALL OF THE REMAINING FILES PRINTED IN STEP (2).
    #   Code can be copied, but user must updated:
    #   query - replace the change number (ie. 2017-###)
    #   tElement.text for File Number (ie. File: 17-###)
    #   tElement.text for Detail Number (ie. Det: ###)
    #   Delete statement for existing file name (ie. co26_Ch_17_###.pdf)
    #   ExportToPDF for new file name (ie. co26_Ch_17_###.pdf)

    for TOCLayer in TOCLayers:
        if TOCLayer.longName == 'TASS_Changes_co26':

            query = """"CHG_NO" = '2017-002'"""

            arcpy.SelectLayerByAttribute_management(TOCLayer, "NEW_SELECTION", query)

            dataframe.extent = TOCLayer.getSelectedExtent()
            dataframe.scale = dataframe.scale * 1.5

            arcpy.SelectLayerByAttribute_management(TOCLayer, "CLEAR_SELECTION")

            for tElement in tElements:
                if tElement.name == 'File Number':
                    tElement.text = 'File: 17-002'

                if tElement.name == 'Detail Number':
                    tElement.text = 'Det: 001'                       

            print 'Exporting Map 2...'

            if arcpy.Exists(pdfpath + 'co26_Ch_17_002.pdf'):
                arcpy.Delete_management(pdfpath + 'co26_Ch_17_002.pdf')

            ExportToPDF(co_mxd, pdfpath + 'co26_Ch_17_002.pdf')

            print 'Complete'

    # 11. Map 3

    for TOCLayer in TOCLayers:
        if TOCLayer.longName == 'TASS_Changes_co26':
                
            query = """"CHG_NO" = '2017-003'"""

            arcpy.SelectLayerByAttribute_management(TOCLayer, "NEW_SELECTION", query)

            dataframe.extent = TOCLayer.getSelectedExtent()
            dataframe.scale = dataframe.scale * 1.5

            arcpy.SelectLayerByAttribute_management(TOCLayer, "CLEAR_SELECTION")

            for tElement in tElements:
                if tElement.name == 'File Number':
                    tElement.text = 'File: 17-003'

                if tElement.name == 'Detail Number':
                    tElement.text = 'Det: 003'                       

            print 'Exporting Map 3...'

            if arcpy.Exists(pdfpath + 'co26_Ch_17_003.pdf'):
                arcpy.Delete_management(pdfpath + 'co26_Ch_17_003.pdf')

            ExportToPDF(co_mxd, pdfpath + 'co26_Ch_17_003.pdf')

            print 'Complete'




except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)





    

