# Geog 375 Final Project
# Created by:  Elaine Carlton
# Due: 5/13/2018

'''
This script creates a selection of Dispatch Calls for Service within 500 feet of marijuana
dispensaries and creates a feature class.  From this feature class, it selects the calls that
resulted in a report and creates a second feature class.  The number of calls for service within
500 feet of a marijuana dispensary are displayed as well as the number of reports. Tables are then
created for both feature classes. All feature classes and tables are copied to a geodatabase that
that is created at the beginning of the script.  Two map documents are created at the end to display
the Report and Call for Service layers respectively. Most of the codes were obtained from the class books,
with a few coming from research online (ArcGIS Online Help).
'''

# Import arcpy module

import arcpy, os, sys, traceback
from arcpy.mapping import *

# Create workspace

arcpy.env.workspace = 'E:\Geog375\ECProject\\'

# Create variable definitions for geoprocessing functions

outpath = 'E:\Geog375\ECProject\\'
out_gdb = 'sacmjgdb.gdb'

YTD_CFS = 'Sacramento_Dispatch_Data_From_Current_Year.shp'
cfsLayer = 'Calls'

Centerlines = 'Centerlines.shp'
streets = 'Streets'

MJ_Location = 'DispensaryAddress.shp'
mjLayer = 'Dispensaries'

search_distance = '500 FEET'

out_cfs_fc =  outpath + 'out_cfs.shp'
select_cfs = 'SelectedCFS'
select_cfs_table = 'select_cfs.dbf'

query = """"Report_Cre" = 'Y'"""

out_report_fc = outpath + 'out_reports.shp'
select_report = 'Reports'
select_report_table = 'select_reports.dbf'

inFeatures = ['Sacramento_Dispatch_Data_From_Current_Year.shp', 'DispensaryAddress.shp', 'out_cfs.shp', 'out_reports.shp', 'Centerlines.shp']
outLocation = 'E:\Geog375\ECProject\sacmjgdb.gdb\\'

# Variables for map PDF's
mappath = outpath + 'ProjectMaps\\'    # Outpath for Map PDF's
mxd = MapDocument (outpath + 'SacMJ.mxd')

author = 'E.Carlton'
CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

# Add try: and except: blocks
try:

# Create a file_geodatabse to direct all of the files created below to.
    if arcpy.Exists(out_gdb):
        arcpy.Delete_management(out_gdb)
    print 'Creating file geodatabase'
    arcpy.CreateFileGDB_management(outpath, out_gdb)    # This code was located with ArcGIS Desktop Help
    print 'File Geodatabase ' + out_gdb + ' created.'

# Make a feature layer for Calls for Service
    print 'Make ' + cfsLayer + ' feature layer.'
    if arcpy.Exists(cfsLayer):
        arcpy.Delete_management(cfsLayer)

    arcpy.MakeFeatureLayer_management(YTD_CFS, cfsLayer)

# Display the number of calls for service in 2018
    result = arcpy.GetCount_management(YTD_CFS)
    print "Number of " + cfsLayer + " in 2018, YTD: "+ str(result)

# Make a feature layer for Dispensaries
    print 'Make ' + mjLayer+ ' feature layer.'
    if arcpy.Exists(mjLayer):
        arcpy.Delete_management(mjLayer)

    arcpy.MakeFeatureLayer_management(MJ_Location, mjLayer)

# Select CFS within 500 feet of a Dispensary
    arcpy.SelectLayerByLocation_management(cfsLayer, "WITHIN_A_DISTANCE", mjLayer, search_distance, "NEW_SELECTION")

# Display the number of selected records from Calls for Service
    result = arcpy.GetCount_management(cfsLayer)
    print "Number of " + cfsLayer + " within a distance of " + search_distance + " of a dispensary: "+ str(result)
    
# Display the number of Dispensaries in Sacramento
    result = arcpy.GetCount_management(mjLayer)
    print "Number of " + mjLayer + " in Sacramento with a query: "+ str(result)

# Create a new feature class of the selected calls for service within 500 feet of a dispensary for analysis
    if arcpy.Exists(out_cfs_fc):
        arcpy.Delete_management(out_cfs_fc)

    arcpy.CopyFeatures_management(cfsLayer, out_cfs_fc)
    print "Copied selected features from " + cfsLayer + " to " + out_cfs_fc

# Create a table of the selected calls for service
    print 'Copying selected calls for service to a new table.'
    if arcpy.Exists(select_cfs_table):
        arcpy.Delete_management(select_cfs_table)
        
    arcpy.CopyRows_management(cfsLayer, select_cfs_table)
    print "Copied selected calls for service from " + cfsLayer + " to " + select_cfs_table

# Make a feature layer for Selected Calls for Service
    print 'Make ' + select_cfs + ' feature layer.'
    if arcpy.Exists(select_cfs):
        arcpy.Delete_management(select_cfs)

    arcpy.MakeFeatureLayer_management(out_cfs_fc, select_cfs)
    
# Select the calls for service for which Dispatch indicated a report was taken
    arcpy.SelectLayerByAttribute_management(select_cfs, "NEW_SELECTION", query)
    result = arcpy.GetCount_management(select_cfs)
    print "Number of " + select_cfs + " with a report: "+ str(result)

# Create a new feature class of the selected calls for service within 500 feet that resulted in a report
    if arcpy.Exists(out_report_fc):
        arcpy.Delete_management(out_report_fc)

    arcpy.CopyFeatures_management(select_cfs, out_report_fc)
    print "Copied selected features from " + select_cfs + " to " + out_report_fc   

# Create a table of the selected reports
    print 'Copying selected reports to a new table.'
    if arcpy.Exists(select_report_table):
        arcpy.Delete_management(select_report_table)
        
    arcpy.CopyRows_management(select_cfs, select_report_table)
    print "Copied selected reports from " + select_cfs + " to " + select_report_table

# Copy feature classes to the geodatabase
    print 'Copying feature classes to the geodatabase'
    arcpy.FeatureClassToGeodatabase_conversion(inFeatures, outLocation) # This code was located with ArcGIS Help
    print 'Feature classes copied to geodatabse'

# Create list of tables
    print 'Creating list of tables'
    tables = arcpy.ListTables()     # The list of tables needs to be created first before copying to the geodatabase
                                    # This code was located with ArcGIS Help
# Copy tables to the geodatabase
    print 'Copying tables to the geodatabase'
    arcpy.TableToGeodatabase_conversion(tables, outLocation)    # This code was located with ArcGIS Help
    print 'Tables copied to the geodatabase'

    print 'This is the end of the geoprocessing script. The creation of two map documents will now begin...'
    
######
# This is the script for the first map documennt, Reports
# Check for Map Document Properties - This is not necessary but it shows some of the basic information about the map document
    print 'Map Document Title: ' + str(mxd.title)
    print 'Map Document Author: ' + str(mxd.author)
    print 'Map Document Summary: ' + str(mxd.summary)
    print 'Map Document Description: ' + str(mxd.description)
    print 'Map Document Last Date Saved: ' + str(mxd.dateSaved)
    print 'Is the Map Document Relative Path Checked? : ' + str(mxd.relativePaths)


# Access the Data Frame Properties - This displays the specifcations for the layout of the map
    dataframe = ListDataFrames (mxd, "Layers") [0]
    print 'Map Frame Map Units: ' + str(dataframe.mapUnits)
    print 'Map Frame Scale: ' + str(dataframe.scale)
    print 'Map Spatial Reference: ' + str(dataframe.spatialReference.name)
    print 'Map Frame Anchor Point X Position (page units): ' + str(dataframe.elementPositionX)
    print 'Map Frame Anchor Point Y Position (page units): ' + str(dataframe.elementPositionY)
    print 'Map Frame Width (page units): ' + str(dataframe.elementWidth)
    print 'Map Frame Height (page units): ' + str(dataframe.elementHeight)

# Get the extent of the Data frame
    mapExtent = dataframe.extent

# Access the layers in the map document
    TOCLayers = ListLayers(mxd)

# Loop through the layers and print the layer names
    for TOCLayer in TOCLayers:
        print 'Layer Name: ' + str(TOCLayer.name)
        print 'Longname: ' + str(TOCLayer.longName)

# Modify Properties of layers
        if TOCLayer.name == 'Centerlines_shp':
            TOCLayer.transparency = 65  # 65% Transparency

# Turn On/Off layers
        if TOCLayer.name == 'DispensaryAddress_shp':
            TOCLayer.visible = True
        
        if TOCLayer.name == 'Centerlines_shp':
            TOCLayer.visible = True

        if TOCLayer.name == 'out_reports_shp':
            TOCLayer.visible = True
         
        if TOCLayer.name == 'out_cfs_shp':
            TOCLayer.visible = False

# Map Element Modifications
    tElements = ListLayoutElements(mxd, 'TEXT_ELEMENT')
    for tElement in tElements:
        if tElement.name == 'Map Title':
            tElement.text = 'Crime Reports Within 500 Feet of a Dispensary'
        if tElement.name == 'Map Author':
            tElement.text = 'Created By: ' + author
        if tElement.name == 'Print Date':
            tElement.text = 'Print Date: ' + str(CUR_DATE)

    if arcpy.Exists(mappath + 'Reports.pdf'):
        arcpy.Delete_management(mappath + 'Reports.pdf')

    print 'Writing PDF file...'

# Create the PDF Document for the Reports layer
    ExportToPDF(mxd, mappath + 'Reports.pdf')
    print 'Created : ' + 'Reports.pdf'
    
################################################
# This is the script for the second map document, CFS (calls for service)
# Loop through the layers
    for TOCLayer in TOCLayers:
        
# Modify Properties of layers
        if TOCLayer.name == 'Centerlines_shp':
            TOCLayer.transparency = 65  # 65% Transparency

# Turn On/Off layers
        if TOCLayer.name == 'DispensaryAddress_shp':
            TOCLayer.visible = True
        
        if TOCLayer.name == 'Centerlines_shp':
            TOCLayer.visible = True

        if TOCLayer.name == 'out_reports_shp':
            TOCLayer.visible = False
         
        if TOCLayer.name == 'out_cfs_shp':
            TOCLayer.visible = True
    
# Map Element Modifications
    tElements = ListLayoutElements(mxd, 'TEXT_ELEMENT')
    for tElement in tElements:
        if tElement.name == 'Map Title':
            tElement.text = 'Calls for Service Within 500 Feet of a Dispensary'
        if tElement.name == 'Map Author':
            tElement.text = 'Created By: ' + author
        if tElement.name == 'Print Date':
            tElement.text = 'Print Date: ' + str(CUR_DATE)

    if arcpy.Exists(mappath + 'CFS.pdf'):
        arcpy.Delete_management(mappath + 'CFS.pdf')

    print 'Writing PDF file...'

# Create the PDF Document
    ExportToPDF(mxd, mappath + 'CFS.pdf')
    print 'Created : ' + 'CFS.pdf'
    
################################    
# END OF SCRIPT
    print "END OF SCRIPT"
    
except:

# Except code obtained from http://pythonprimer.urbandalespatial.com/resources (Prof Jennings)

    # Except Statement
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # Prints error messages in the Progress dialog box
    arcpy.AddError(msgs)   
    arcpy.AddError(pymsg)

    # Prints messages to the Python Shell
    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))

    print arcpy.GetMessages(1)
