# -*- coding: utf-8 -*-
"""
Map Book Production Solution ArcGIS Pro

Nathan Jennings
Created on:  04.05.2019
Updated on:  03.14.2020
"""

print ("Exercise 9 Stump Code - Map Production\n")

import arcpy, sys, traceback, datetime
#from arcpy.mapping import *   # Eliminates the need to write arcpy.mapping
                              # before each mapping module related class, function
                              # or method

author = "N. Jennings" # Change this to your name

# reformat date to MM.DD.YYYY
# NOTE: using a lowercase %y will result in MM.DD.YY format
# See Python.org or text regarding the datetime module

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

try:

    # Get the map document.
    # In this case a custom template set up for map production
    # change the paths as needed to run the script form a local system
    #datapath = 'C:\\PythonPrimer\\Chapter09\\'
    ppath = "C:\\Users\\Nate\\Documents\\ArcGIS\\Projects\\ProMapModule\\"
    
    #mappath = datapath + "MyData\\Maps\\"    # output for PDFs
    mappath = "c:\\temp\\"
    aprx = arcpy.mp.ArcGISProject(ppath + "MapBookProduction.aprx")
    
    # get a list of Maps that contain layers
    # [0] inicates the first (or only map from the map list, in this case)
    
    maplist = aprx.listMaps("Map") [0]  # the name of the Map tab is "Map"
    layout = aprx.listLayouts("Layout")[0]
    mapframe = layout.listElements("MAPFRAME_ELEMENT", "Map Frame")[0]    
   
    
    # get a list of layers
    for TOCLayer in maplist.listLayers():
       
        print ("Layer Name " + str(TOCLayer.longName)) 
        if TOCLayer.longName == "Detail Map\\Neighborhoods":
            print ("inside TOC")
            NHLayer = TOCLayer  # Assigning the specific TOCLayer
                                # in this case the neighborhood layer to
                                # the variable NHLayer


                                
    # Out dented here to create the cursor outside of the layer loop

    # !!!! Bonus !!!!

    # Before the cursor add code to add the City Boundary.lyrx
    # to the data frame and the the appropriate code to have the new
    # layer show up in the legend.        

    
    
    print ("Added City Boundary layer")

    # The above bonus would be implemented before the search cursor

    #  !!!!! End of Bonus!!!!
    
    #legend = layout.listElements("LEGEND_ELEMENT", "Legend")[0]

    # 1. Create a search cursor on the NHLayer
    
    field_name = ["NAME"]
    with arcpy.da.SearchCursor(NHLayer, field_name) as NHrows:
    
        # !!!! indent here (because of the "with" statement)


        # 2.  Create a for loop to loop through the individual rows
        #   of the neighborhood layer.


        for NHrow in NHrows:
    
        # !!!! extra indent here (and on down through the code), again because of the "with" statement

            # Indented here to loop over the individual rows of the cursor
        
            # 3.   Set a variable to the Neighborhood's NAME field (holds the name
            #      of the neighborhood
            

            NHName = NHrow[0]  # remember, a Python list index is used
                               # to obtain the value for a row and column
                               # where column is the "NAME" field

            


            # 4.    Create a query variable to that uses the neighborhood name
            #   variable.  The syntax will be similar to this:
            #   query = """"NAME" = '""" + NHName + """'""", where NHName is the
            #   neighborhood variable
            
            #   !!! This step is provided for you

            query = """"NAME" = '""" + NHName + """'"""

            # 5. Assign the Neighborhood Layer's definitionQuery property to
            #    the query variable


            # 6. Set the data frame's extent property to to the layer's extent using
            #    the getExtent() method.  NOTE:  mapframe is already defined above
            

            # 7. Set the dataframe's scale propety to dataframe.scale * 1.1
            #    NOTE:  dataframe is already defined above

                    
            # 8. Create a list variable of the layout elements that are "text" elements.

            tElements = layout.listElements("TEXT_ELEMENT")

            # 9.  Within the loop over the search cursor rows, create another
            #     for loop over the text elements.  The following should be used.

            for tElement in tElements:
        

                # Indented again here to loop over layout elements


                #     You will need to use conditional statements in this section.

                #     1. 'Map Title' element's text property should be 'Neighborhood Map'
                #     


                #     2. 'Neighborhood Name' elements text property should be assigned
                #      the unique name of the neighborhood.  HINT:  use the neighborhood
                #      name variable (NHName) you defined above.

                #      2a. the X position of the neighborhood name should be 9.1

                

                    # !!!!! Bonus !!!!!

                    #     Put in a conditional statement that checks for the
                    #     Neighborhood Name 'Midtown_Winn Park_Capital Avenue'
                    #     If this is true, set the X position to 8.55

                    
                # ''''' End Bonus !!!!

                #      3. 'Author' element's text property should be assigned to the
                #      author variable defined at the top of the code

                

                #      4. 'Print Date' element's text property should be assigned to
                #       the CUR_DATE variable defined at the top of the code.
                #      Remember to use str() with this variable to cast the date
                #      to a string

            # Out-dented here, since the changes to the layout elements are complete

            #      Change the indent (out-dent) from the text elements loop

            #      These comments have been "out dented" to show where the change
            #      in indentation occurs.

            #      Create a PDF of the map with the unique changes

            # 10.  Add a check to see if the unique map name PDF file exists
            #      if it does, then delete it.


            #      Use the mappath variable plus the Neighborhood varaible you
            #      defined above to build the PDF file name.  All map files will
            #      end with '_map.pdf' string.

            # 11.  Use the exportToPDF routine to export the map
            #      use the layout.exportToPDF().  The variable "layout" is
            #      defined above to point to the specific map layout.
            #      the exportToPDF routine is related to the layout tab

            #      Write a print statement that reports the map was printed

            #      Use the neighborhood name variable defined above in this print statement


        
    print ('Completed Map Production')


except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    #https://pro.arcgis.com/en/pro-app/arcpy/get-started/error-handling-with-python.htm#GUID-67136187-389D-4627-93CB-C47DFE1E46F2
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +  str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))
