# Exercise 9 - Stump Code
# Created by: Nathan Jennings
#             www.urbandalespatial.com
# Created on: 03.19.2011
# Updated on: 10.30.2011
# Copyright:  2011

import arcpy, sys, traceback, datetime
from arcpy.mapping import *   # Eliminates the need to write arcpy.mapping
                              # before each mapping module related class, function
                              # or method

author = 'N. Jennings'  # Change this to your name

# reformat date to MM.DD.YYYY
# NOTE: lowercase %y will result in MM.DD.YY format
# See Python.org or text regarding the datetime module

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

try:

    # Get the map document.
    # In this case a custom template set up for map production

    # Change the paths to match the location of your data and folders
    datapath = 'C:\\PythonPrimer\\Chapter09\\'
    mappath = datapath + 'MyData\\Maps\\'
    mxd = MapDocument(datapath + 'Map_Template.mxd')

    # Get a list of data frames
    # [0] inicates the first (or only data frame)
    dataframe = ListDataFrames(mxd, "Layers") [0]

    
    # Get a list of layers in the table of contents of the map document
    TOCLayers = ListLayers(mxd) 

    # loop through the layers
    for TOCLayer in TOCLayers:
        print 'Layer Name ' + str(TOCLayer.name)
        #if NHLayer.longName == 'Detail Map\Neighborhoods':
        print 'Longname ' + str(TOCLayer.longName)  # longName provides
                                                    # the ability to use
                                                    # "Group Layers"

        if TOCLayer.longName == 'Detail Map\Neighborhoods':
            print 'inside TOC'
            NHLayer = TOCLayer  # Assing the specific TOCLayer to
                                # the variable NHLayer

   

    # Out dented here to create the cursor outside of the layer loop

    # !!!! Bonus !!!!

    # Before the cursor add code to add the City Boundary.lyr file
    # to the data frame and the the appropriate code to have the new
    # layer show up in the legend.

    # The above bonus would be implemented before the search cursor

    #  !!!!! End of Bonus!!!!

    # 1.  Create a search cursor on the NHLayer

    NHrows = arcpy.SearchCursor(NHLayer)

    


    # 2.  Create a for loop to loop through the individual rows
    #   of the neighborhood layer.

    for NHrow in NHrows:

        

        # Indented here to loop over the individual rows of the cursor
    
        # 3.   Set a variable to the Neighborhood's NAME field (holds the name
        #   of the neighborhood

        NHName = NHrow.NAME


        # 4.    Create a query variable to that uses the neighborhood name
        #   variable.  The syntax will be similar to this:
        #   query = '"NAME" = \'' + NHName + '\'', where NHName is the
        #   neighborhood variable

        # 5. Assign the Neighborhood Layer's definitionQuery property to
        #    the query variable

        # 6. Set the data frame's extent property to to the layer's extent using
        #    the getExtent() method.  NOTE:  dataframe is already defined above

        # 7. Set the dataframe's scale propety to dataframe.scale * 1.1
        #    NOTE:  dataframe is already defined above


        # 8. Create a list variable of the layout elements that are "text" elements.

        tElements = ListLayoutElements(mxd, "TEXT_ELEMENT")

        # 9.  Within the loop over the search cursor rows, create another
        #     for loop over the text elements.  The following should be used.

        for tElement in tElements:
        

            # Indented again here to loop over layout elements


            #     You will need to use conditional statements in this section.

            #     'Map Title' element's text property should be 'Neighborhood Map'
            #     'Neighborhood Name' elements text property should be assigned
            #      the unique name of the neighborhood.  HINT:  use the neighborhood
            #      name variable you defined above.
            #      the X position of the neighborhood name should be 9.1

                # !!!!! Bonus !!!!!

                #     Put in a conditional statement that checks for the
                #     Neighborhood Name 'Midtown_Winn Park_Capital Avenue'
                #     If this is true, set the X position to 8.55

                # ''''' End Bonus !!!!

            #      'Author' element's text property should be assigned to the
            #      author variable defined at the top of the code

            #      'Print Date' element's text property should be assigned to
            #      the CUR_DATE variable defined at the top of the code.

            #      Remember to use str() with this variable to cast the date
            #      to a string

        # Out-dented here, since the changes to the layout elements are complete

        #      Change the indent (out-dent) from the text elements loop

        #      These comments have been "out dented" to show where the change
        #      in indentation occurs.

        #      Create a PDF of the map with the unique changes

        # 10.  Add a check to see if the unique map name PDF file exists
        #      if it does, then delete it.

        #      Use the mappath variable plus the Neighborhood varaible you
        #      defined above to build the PDF file name.  All map files will
        #      end with '_map.pdf' string.

        # 11.  Use the ExportToPDF routine to export the map

        #      Write a print statement tha reports the map was printed

        #      Use the neighborhood name variable defined above in this print statement

    del mxd

    print 'Completed Unique Map Sheets'

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)



