# -*- coding: utf-8 -*-
"""
Map Book Production Solution ArcGIS Pro

Nathan Jennings
Created on:  04.05.2019
Updated on:  02.22.2021
"""

'''
Update:  02.22.2021

# getLayerExtent
# getLayerExtent is correct with "zoom to selected features, etc"
# See https://pro.arcgis.com/en/pro-app/latest/arcpy/mapping/mapframe-class.htm
# for details on getLayerExtent(layer, {selection_only}, {symbolized_extent})
# {selection_only} parameter defaults to TRUE

# setExtent
# setExtent is corret
# See https://pro.arcgis.com/en/pro-app/latest/arcpy/mapping/camera-class.htm
# for setExtent(extent)


'''


print ("Exercise 9 Stump Code - Map Production\n")

import arcpy, sys, traceback, datetime


author = "N. Jennings" # Change this to your name

# reformat date to MM.DD.YYYY
# NOTE: using a lowercase %y will result in MM.DD.YY format
# See Python.org or text regarding the datetime module

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

try:

    # Use the preconfigured MapBookProduction.aprx Pro project file
    
    # change the paths as needed to run the script form a local system
    # Pro project path
    ppath = "C:\\Users\\Nate\\Documents\\ArcGIS\\Projects\\ProMapModule\\"
    
    # output for PDFs.  Change as desired.
    
    mappath = "c:\\temp\\"

    # assign the pro project file to a variable
    aprx = arcpy.mp.ArcGISProject(ppath + "MapBookProduction.aprx")
    
    # get a list of Maps that contain layers
    # [0] inicates the first (or only map from the map list, in this case)
    
    maplist = aprx.listMaps("Map") [0]  # the name of the Map tab is "Map"
    layout = aprx.listLayouts("Layout")[0] # the name of the Layout tab is "Layout"

    # the name of the map frame in the layout is "Map Frame"
    mapframe = layout.listElements("MAPFRAME_ELEMENT", "Map Frame")[0]    
   
    
    # get a list of layers
    for TOCLayer in maplist.listLayers():
       
        print ("Layer Name " + str(TOCLayer.longName)) 
        if TOCLayer.longName == "Detail Map\\Neighborhoods":
            print ("inside TOC")
            NHLayer = TOCLayer  # Assigning the specific TOCLayer
                                # in this case the neighborhood layer to
                                # the variable NHLayer


                                
    # Out dented here to create the cursor outside of the layer loop

    # !!!! Bonus !!!!

    # Before the cursor add code to add the City Boundary.lyrx
    # to the data frame and the the appropriate code to have the new
    # layer show up in the legend.        

    
    
    print ("Added City Boundary layer")

    # The above bonus would be implemented before the search cursor

    #  !!!!! End of Bonus!!!!
    
    

    # Create a search cursor on the NHLayer
    
    field_name = ["NAME"]
    with arcpy.da.SearchCursor(NHLayer, field_name) as NHrows:
    
        # !!!! indent here (because of the "with" statement)


        # Create a for loop to loop through the individual rows
        # of the neighborhood layer.


        for NHrow in NHrows:
    
        # !!!! extra indent here (and on down through the code), again because of the "with" statement

            # Indented here to loop over the individual rows of the cursor
        
            # Set a variable to the Neighborhood's NAME field (holds the name
            # of the neighborhood)

            # Note:  The "NAME" field is the only field in the field_name Python list above
            # so, the "0" is the position of the NAME field in the field_name Python list

            NHName = NHrow[0]  # remember, a Python list index is used
                               # to obtain the value for a row and column
                               # where column is the "NAME" field

            


            # Create a query variable to that uses the neighborhood name variable NHName
            # variable.  The syntax will be similar to this:
            
            
            #   !!! This step is provided for you

            query = """"NAME" = '""" + NHName + """'"""

            # Assign the Neighborhood Layer's definitionQuery property to
            # the query variable


            # Set the mapframe's extent property to to the layer's extent using
            # the getLayerExtent() method to "get" the extent of the neighborhood layer
            # use the setExtent() to actually "set" the mapframe's extent to the neighborhood layer.
            # NOTE:  mapframe is already defined toward the top of the script.
            

            # Set the mapframe's scale propety with a factor of * 1.1

                    
            # Create a list variable of the layout elements that are "text" elements.

            tElements = layout.listElements("TEXT_ELEMENT")

            # Within the loop over the search cursor rows, create another
            # for loop over the text elements.  The following should be used.

            for tElement in tElements:
        

                # Indent again to start processing the individual text elements
    
                # You will need to use conditional statements in this section.
        
                # Map Title
                
                # 'Map Title' element's text property should be the actual words 'Neighborhood Map'
                # Set the elementPostionX = 8.7

                # Neighborood Name
                
                # 'Neighborhood Name' elements text property should be assigned
                # the unique name of the neighborhood.  HINT:  use the neighborhood
                # name variable (NHName) you defined above.

                # Set the elementPositionX = 9.1

                # !!!! Bonus Section !!!!
                    # Set up a condition to check for the neighborhoo name is
                    # 'Midtown_Winn Park_Capital Avenue' (just as it is spelled out)
                    # if it does, change the elementPositionX to 8.55

                # !!!! end of Bonus Section !!!!
                
                # Author
                
                # 'Author' element's text property should be assigned to the
                # author variable defined at the top of the code (i.e. you, the student's name)

                
                # Print Date
                
                # 'Print Date' element's text property should be assigned to
                # the CUR_DATE variable defined at the top of the code.
                # Remember to use str() with this variable to cast the date
                # to a string

                

            # Out-dented here, since the changes to the layout elements are complete

            # Change the indent (out-dent) from the text elements loop

            # These comments have been "out dented" to show where the change
            # in indentation occurs.

            # Create a PDF of the map with the unique changes

            # Add a check to see if the unique map name PDF file exists
            # if it does, then delete it.


            # Use the mappath variable plus the Neighborhood varaible (NHName) you
            # defined above to build the PDF file name.  All map files will
            # end with '_map.pdf' string.

            # Use the exportToPDF routine to export the map
            # use the layout.exportToPDF().  The variable "layout" is
            # defined above to point to the specific map layout.
            # the exportToPDF routine is related to the layout tab

            # Write a print statement that reports the map was printed

            # Use the neighborhood name variable defined above in this print statement


        
    print ('Completed Map Production')


except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    #https://pro.arcgis.com/en/pro-app/arcpy/get-started/error-handling-with-python.htm#GUID-67136187-389D-4627-93CB-C47DFE1E46F2
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +  str(sys.exc_info()[1])
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print (msgs)
    print (pymsg)
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print (arcpy.GetMessages(1))
