# Demo 5a  Create Feature Layer using an expression
# Created by:  Nathan Jennings
#              www.urbandalespatial.com
# Created on:  01.14.2011
# Updated on:  12.13.2014
# Copyright:   2011

'''
Example of using the Make Feature Layer tool and prints the effect of the
query xpression (where clause) parameter when the where clause is used v.
not used.

The number of "selected" features are printed to the screen.


'''
print 'Demo 5a - Create Feature Layer with Expression\n'

import arcpy, sys, traceback

# Change the path as needed
arcpy.env.workspace = "C:\\PythonPrimer\\Chapter05\\Data\\"

streets = "Sacramento_Streets.shp"

street_layer = "street_layer"

try:


    # print the number of records in the feature class
    result = arcpy.GetCount_management(streets) 
    print "Number of features in the feature class " + streets + " : " + str(result)

    # check to see if the feature layer exists; if so, delete it
    if arcpy.Exists(street_layer):
        arcpy.Delete_management(street_layer)

    # make the feature layer
    arcpy.MakeFeatureLayer_management(streets, street_layer)

    # print the number of records in the feature layer without a query
    result = arcpy.GetCount_management(street_layer) 
    print "Number of features in the feature layer " + street_layer + " without a query: "+ str(result)

    # check to see if the feature layer exists; if so, delete it
    if arcpy.Exists(street_layer):
        arcpy.Delete_management(street_layer)

    # create a feature layer using a query

    query = """"CLASS" = 'H'"""

    # make the feature layer using the query parameter
    arcpy.MakeFeatureLayer_management(streets, street_layer, query)

    # print the number of records in the feature layer with query
    result = arcpy.GetCount_management(street_layer) 
    print "Number of features in the feature layer " + street_layer + " with a query: "+ str(result)
    



except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
