# G Wickham - Final - Student Yields
# Created by: Geri Wickham
# Created on: 04.24.2016
# Updated on: 05.07.2016

'''
04.24.2016

This script will summarize student and parcel data for
an elementary school attendance area for use in calculating
student yields.

'''

import arcpy, sys, os, traceback, datetime
from arcpy.mapping import *

author = 'Geri Wickham'
CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

# Set workspace and datapaths

datapath = 'C:\\Users\\Geri\\Documents\\College\\375\\Final\\'
outpath = datapath + 'MyData\\'
mappath = datapath + 'MyData\\Maps\\'
mxd = MapDocument(datapath + 'Map_Template.mxd') # Map doc created by Nathan Jennings
arcpy.env.workspace = datapath + 'Data'

# Set variables
boundary_fc = "boundary.shp"
boundary_fl = "boundary_fl"
students_fc = "students.shp"
students_fl = "students_fl"
parcel_fc = "parcels.shp"
parcel_fl = "parcels_fl"


try:
     # Get a list of data frames
     dataframe = ListDataFrames(mxd, "Layers") [0]

     # Get list of layers in the TOC of the map
     TOCLayers = ListLayers(mxd)

     # Loop through the layers
     for TOCLayer in TOCLayers:
         print 'Layer Name: ' + str(TOCLayer.name)
         print 'Longname: ' + str(TOCLayer.longName)

     if TOCLayer.longName == 'Detail Map\Boundary':
         print 'inside TOC'
         
     SCHLayer = TOCLayer

     # Create a search cursor for the boundary layer
     SCHName = ["ELEM_DESC"]

     with arcpy.da.SearchCursor(SCHLayer, SCHName) as SCHrows:

        # Create loop to go through rows of boundary layer
        for SCHrow in SCHrows:

            # Set variable to the boundary name field
            SCHName = SCHrow[0]

            # Create query to use the school name variable
            query = """"ELEM_DESC" = '""" + SCHName + """'"""

            # Assign the school boundary layer definition query
            SCHLayer.definitionQuery = query

            # Set dataframe extent property
            dataframe.extent = SCHLayer.getExtent()
            dataframe.scale = dataframe.scale * 1.1

            # Select attendance boundary
            arcpy.SelectLayerByAttribute_management(SCHLayer, "NEW_SELECTION", query)
        
            print "Finished selecting boundary"

            # Select students within the selected boundary
            SCHStats = outpath + SCHName + '_students.dbf'
         
            # Make a feature layer for students
            if arcpy.Exists(students_fl):
                 arcpy.Delete_management(students_fl)

            arcpy.MakeFeatureLayer_management(students_fc, students_fl)

            # Select students within the selected boundary
            arcpy.SelectLayerByLocation_management(students_fl, "INTERSECT", \
                                           SCHLayer, "", "NEW_SELECTION")

            print "Finished selecting students within selected bounary"
            
            # Check to see if SCHStats exists
            if arcpy.Exists(SCHStats):
                arcpy.Delete_management(SCHStats)
                
            # Summary selected students by grade level count
            arcpy.Frequency_analysis(students_fl, SCHStats, "GRD", "")

            print "Finished summarizing student grade levels"

            # Select parcels within the selected boundary
            ParcelStats = outpath + SCHName + '_parcels.dbf'
            
            # Make a feature layer for parcels
            if arcpy.Exists(parcel_fl):
                 arcpy.Delete_management(parcel_fl)

            arcpy.MakeFeatureLayer_management(parcel_fc, parcel_fl)

            # Select parcels within the selected boundary
            arcpy.SelectLayerByLocation_management(parcel_fl, "INTERSECT", \
                                               SCHLayer, "", "NEW_SELECTION")

            # Select only residential parcels

            # Set query to residential only
            query1 = """"LANDUSE" Like 'A%'"""

            # Process selection
            arcpy.SelectLayerByAttribute_management(parcel_fl, "SUBSET_SELECTION", query1)
            
            # Check to see if ParcelStats exists
            if arcpy.Exists(ParcelStats):
               arcpy.Delete_management(ParcelStats)
      
            # Summary selected parcels by landuse
            arcpy.Frequency_analysis(parcel_fl, ParcelStats, "LANDUSE", "")
            
            print "Finished summarizing parcel data"    
      
            # Create a list variable of the layout elements that are "text" elements.
            tElements = ListLayoutElements(mxd, "TEXT_ELEMENT")
                
            # Create another for loop over the text elements.
            for tElement in tElements:
             
                if tElement.name == 'Map Title':
                    tElement.text = 'Boundary Map'

                if tElement.name == 'School':
                    tElement.text = SCHName
                    tElement.elementPositionX = 9.1
 
                # Insert author name
                if tElement.name == 'Author':
                    tElement.text = author

                # Print Date  
                if tElement.name == 'Print Date':
                    tElement.text = str(CUR_DATE)

            SCHMap = SCHName + '_Map.pdf'

            if arcpy.Exists(mappath + SCHMap):
                arcpy.Delete_management(mappath + SCHMap)

            # Export the map

            ExportToPDF(mxd, mappath + SCHMap)

            print 'Map: ' + SCHMap + ' exported'

     del mxd
     print 'Completed Boundary Dot Maps'
    
except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
