
import arcpy, sys, traceback, datetime
from arcpy.mapping import *   # Eliminates the need to write arcpy.mapping
                              # before each mapping module related class, function
                              # or method

arcpy.env.overwriteOutput=True

author = 'G. Paarmann'  

# reformat date to MM.DD.YYYY
# NOTE: lowercase %y will result in MM.DD.YY format
# See Python.org or text regarding the datetime module

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

try:

    # Get the map document.
    # In this case a custom template set up for map production

    # Change the paths to match the location of your data and folders
    datapath = 'C:\\Users\\Gabriel\\Desktop\\\New_folder\\'
    mappath = datapath + 'MyData\\Maps\\'
    mxd = MapDocument(datapath + 'PYTHON_PROJECT.mxd')


    # Get a list of data frames
    # [0] inicates the first (or only data frame)
    dataframe = ListDataFrames(mxd, "Layers") [0]


# Get a list of layers in the table of contents of the map document
    TOCLayers = ListLayers(mxd) 

    # loop through the layers
    for TOCLayer in TOCLayers:
        print 'Layer Name ' + str(TOCLayer.name)
        print 'Longname ' + str(TOCLayer.longName)  # longName provides
                                                    # the ability to use
                                                    # "Group Layers"

    tElements = ListLayoutElements (mxd, "TEXT_ELEMENT")
    print 'Processing text elements...'
    for tElement in tElements:
                if tElement.name == 'A':
                    tElement.text = 'APPEW'
                if tElement.name == 'B':
                    tElement.text = 'Print Date: ' + str(CUR_DATE)
                if tElement.name == 'C':
                    tElement.text = 'Gabriel Paarmann'                
    #Create variable for Shapefiles
    arcpy.env.workspace = r'C:\Users\Gabriel\Desktop\New_folder\CIS_Data_1.gdb'

    # Hook into the data frame where you want to add the layer  
    df  = arcpy.mapping.ListDataFrames(mxd)[0]  
  
    # Create a Layer object  
    lyr = arcpy.management.MakeFeatureLayer('APPEW' , "APPEW_Layer").getOutput(0)  
  
    # Add the layer object to the map  
    arcpy.mapping.AddLayer(df, lyr)  

     #      Create a PDF of the map with the unique changes

            # 10.  Add a check to see if the unique map name PDF file exists
            #      if it does, then delete it.


    if arcpy.Exists(mappath + 'APPEW.pdf'):
        arcpy.Delete_management(mappath + 'APPEW.pdf')

            #      Use the mappath variable plus the Neighborhood varaible you
            #      defined above to build the PDF file name.  All map files will
            #      end with '_map.pdf' string.

            # 11.  Use the ExportToPDF routine to export the map

    ExportToPDF(mxd, mappath + 'APPEW.pdf')
    print 'created: ' + 'APPEW.pdf'

            #      Write a print statement that reports the map was printed

            #      Use the neighborhood name variable defined above in this print statement

    print 'Completed APPEW Map'

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)




