# Created on: 2017-05-10 11:46:03.00000
# created by Gabriel Paarmann
# Import arcpy module
import arcpy


# Variables:
CIS_DATA = "CIS_DATA"
OIL_UWST_QUERY = "OIL_UWST_QUERY"
OIL_UWASTE_View = "OIL_UWASTE_VIEW"
OIL_UWST_XY = "OIL_UWST_XY"
OIL_UWSTE = "\\\\ewgis01\\Shares\\IT_GIS\\Projects\\Solid_Waste\\GPaarmann\\Projects\\Playground\\ARC_Project\\CIS_Data.gdb\\OIL_UWSTE"
ABNCU_QUERY = "ABNCU_QUERY"
ABNCU_view = "ABNCU_VIEW"
ABNCU_XY = "ABNCU_XY"
ABNCU = "\\\\ewgis01\\Shares\\IT_GIS\\Projects\\Solid_Waste\\GPaarmann\\Projects\\Playground\\ARC_Project\\CIS_Data.gdb\\ABNCU"
BIN_QUERY = "BIN_QUERY"
BIN_View = "BIN_VIEW"
BIN_XY = "BIN_XY"
BIN = "\\\\ewgis01\\Shares\\IT_GIS\\Projects\\Solid_Waste\\GPaarmann\\Projects\\Playground\\ARC_Project\\CIS_Data.gdb\\BIN"
APPEW_QUERY = "APPEW_QUERY"
APPEW_View = "APPEW_VIEW"
APPEW_XY = "APPEW_XY"
APPEW = "\\\\ewgis01\\Shares\\IT_GIS\\Projects\\Solid_Waste\\GPaarmann\\Projects\\Playground\\ARC_Project\\CIS_Data.gdb\\APPEW"
KICKS_QUERY = "KICKS_QUERY"
KICKS_View = "KICKS_VIEW"
KICKS_XY = "KICKS_XY"
KICKS = "\\\\ewgis01\\Shares\\IT_GIS\\Projects\\Solid_Waste\\GPaarmann\\Projects\\Playground\\ARC_Project\\CIS_Data.gdb\\KICKS"

# Create Query Table OIL_UWST
arcpy.MakeQueryTable_management("CIS_DATA", OIL_UWST_QUERY, "USE_KEY_FIELDS", "", "CIS_DATA.OBJECTID_1 #;CIS_DATA.OBJECTID #;CIS_DATA.FO_ID #;CIS_DATA.FA_ID #;CIS_DATA.CRE_DTTM #;CIS_DATA.SCHED_DT #;CIS_DATA.SCHED_TM #;CIS_DATA.DISP_GRP_CD #;CIS_DATA.FA_TYPE_CD #;CIS_DATA.INSTRUCTIONS #;CIS_DATA.DESCR254 #;CIS_DATA.REP_CD #;CIS_DATA.FO_STATUS_FLG #;CIS_DATA.WORK_DTTM #;CIS_DATA.EXTRACT_DTTM #;CIS_DATA.SP_ID #;CIS_DATA.PREM_ID #;CIS_DATA.ADDRESS1 #;CIS_DATA.CITY #;CIS_DATA.STATE #;CIS_DATA.POSTAL #;CIS_DATA.APN #;CIS_DATA.CU_XCOORD #;CIS_DATA.CU_YCOORD #;CIS_DATA.OP_AREA_CD #", "(SCHED_DT >= date '2017-03-02 00:00:00' AND SCHED_DT <= date '2017-03-31 00:00:00') AND (FA_TYPE_CD IN( 'OIL', 'U-WASTE' ))")

# Create OIL_UWASTE Table View
arcpy.MakeTableView_management(OIL_UWST_QUERY, OIL_UWASTE_View, "FA_TYPE_CD IN( 'OIL', 'U-WASTE' )", "", "CIS_DATA_OBJECTID_1 CIS_DATA_OBJECTID_1 VISIBLE NONE;CIS_DATA_OBJECTID CIS_DATA_OBJECTID VISIBLE NONE;CIS_DATA_FO_ID CIS_DATA_FO_ID VISIBLE NONE;CIS_DATA_FA_ID CIS_DATA_FA_ID VISIBLE NONE;CIS_DATA_CRE_DTTM CIS_DATA_CRE_DTTM VISIBLE NONE;CIS_DATA_SCHED_DT CIS_DATA_SCHED_DT VISIBLE NONE;CIS_DATA_SCHED_TM CIS_DATA_SCHED_TM VISIBLE NONE;CIS_DATA_DISP_GRP_CD CIS_DATA_DISP_GRP_CD VISIBLE NONE;CIS_DATA_FA_TYPE_CD CIS_DATA_FA_TYPE_CD VISIBLE NONE;CIS_DATA_INSTRUCTIONS CIS_DATA_INSTRUCTIONS VISIBLE NONE;CIS_DATA_DESCR254 CIS_DATA_DESCR254 VISIBLE NONE;CIS_DATA_REP_CD CIS_DATA_REP_CD VISIBLE NONE;CIS_DATA_FO_STATUS_FLG CIS_DATA_FO_STATUS_FLG VISIBLE NONE;CIS_DATA_WORK_DTTM CIS_DATA_WORK_DTTM VISIBLE NONE;CIS_DATA_EXTRACT_DTTM CIS_DATA_EXTRACT_DTTM VISIBLE NONE;CIS_DATA_SP_ID CIS_DATA_SP_ID VISIBLE NONE;CIS_DATA_PREM_ID CIS_DATA_PREM_ID VISIBLE NONE;CIS_DATA_ADDRESS1 CIS_DATA_ADDRESS1 VISIBLE NONE;CIS_DATA_CITY CIS_DATA_CITY VISIBLE NONE;CIS_DATA_STATE CIS_DATA_STATE VISIBLE NONE;CIS_DATA_POSTAL CIS_DATA_POSTAL VISIBLE NONE;CIS_DATA_APN CIS_DATA_APN VISIBLE NONE;CIS_DATA_CU_XCOORD CIS_DATA_CU_XCOORD VISIBLE NONE;CIS_DATA_CU_YCOORD CIS_DATA_CU_YCOORD VISIBLE NONE;CIS_DATA_OP_AREA_CD CIS_DATA_OP_AREA_CD VISIBLE NONE")

# Create OIL_UWST XY Event Layer
arcpy.MakeXYEventLayer_management(OIL_UWASTE_View, "CIS_DATA.CU_XCOORD", "CIS_DATA.CU_YCOORD", OIL_UWST_XY, "PROJCS['NAD_1983_StatePlane_California_II_FIPS_0402_Feet',GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]],PROJECTION['Lambert_Conformal_Conic'],PARAMETER['False_Easting',6561666.666666666],PARAMETER['False_Northing',1640416.666666667],PARAMETER['Central_Meridian',-122.0],PARAMETER['Standard_Parallel_1',38.33333333333334],PARAMETER['Standard_Parallel_2',39.83333333333334],PARAMETER['Latitude_Of_Origin',37.66666666666666],UNIT['Foot_US',0.3048006096012192]];-115211800 -93821500 36983428.0573515;-100000 10000;-100000 10000;3.28083333333333E-03;0.001;0.001;IsHighPrecision", "")

#Copy Features OIL
arcpy.CopyFeatures_management(OIL_UWST_XY, OIL_UWSTE, "", "0", "0", "0")

# Create Query Table ABNCU
arcpy.MakeQueryTable_management("CIS_DATA", ABNCU_QUERY, "USE_KEY_FIELDS", "", "CIS_DATA.OBJECTID_1 #;CIS_DATA.OBJECTID #;CIS_DATA.FO_ID #;CIS_DATA.FA_ID #;CIS_DATA.CRE_DTTM #;CIS_DATA.SCHED_DT #;CIS_DATA.SCHED_TM #;CIS_DATA.DISP_GRP_CD #;CIS_DATA.FA_TYPE_CD #;CIS_DATA.INSTRUCTIONS #;CIS_DATA.DESCR254 #;CIS_DATA.REP_CD #;CIS_DATA.FO_STATUS_FLG #;CIS_DATA.WORK_DTTM #;CIS_DATA.EXTRACT_DTTM #;CIS_DATA.SP_ID #;CIS_DATA.PREM_ID #;CIS_DATA.ADDRESS1 #;CIS_DATA.CITY #;CIS_DATA.STATE #;CIS_DATA.POSTAL #;CIS_DATA.APN #;CIS_DATA.CU_XCOORD #;CIS_DATA.CU_YCOORD #;CIS_DATA.OP_AREA_CD #", "(SCHED_DT >= date '2017-03-02 00:00:00' AND SCHED_DT <= date '2017-03-31 00:00:00') AND (FA_TYPE_CD IN('ABNCU', 'BULKYSVC', 'SPCSVC'))")

# Create ABNCU Table View
arcpy.MakeTableView_management(ABNCU_QUERY, ABNCU_view, "FA_TYPE_CD IN('ABNCU', 'BULKYSVC', 'SPCSVC')", "", "CIS_DATA_OBJECTID_1 CIS_DATA_OBJECTID_1 VISIBLE NONE;CIS_DATA_OBJECTID CIS_DATA_OBJECTID VISIBLE NONE;CIS_DATA_FO_ID CIS_DATA_FO_ID VISIBLE NONE;CIS_DATA_FA_ID CIS_DATA_FA_ID VISIBLE NONE;CIS_DATA_CRE_DTTM CIS_DATA_CRE_DTTM VISIBLE NONE;CIS_DATA_SCHED_DT CIS_DATA_SCHED_DT VISIBLE NONE;CIS_DATA_SCHED_TM CIS_DATA_SCHED_TM VISIBLE NONE;CIS_DATA_DISP_GRP_CD CIS_DATA_DISP_GRP_CD VISIBLE NONE;CIS_DATA_FA_TYPE_CD CIS_DATA_FA_TYPE_CD VISIBLE NONE;CIS_DATA_INSTRUCTIONS CIS_DATA_INSTRUCTIONS VISIBLE NONE;CIS_DATA_DESCR254 CIS_DATA_DESCR254 VISIBLE NONE;CIS_DATA_REP_CD CIS_DATA_REP_CD VISIBLE NONE;CIS_DATA_FO_STATUS_FLG CIS_DATA_FO_STATUS_FLG VISIBLE NONE;CIS_DATA_WORK_DTTM CIS_DATA_WORK_DTTM VISIBLE NONE;CIS_DATA_EXTRACT_DTTM CIS_DATA_EXTRACT_DTTM VISIBLE NONE;CIS_DATA_SP_ID CIS_DATA_SP_ID VISIBLE NONE;CIS_DATA_PREM_ID CIS_DATA_PREM_ID VISIBLE NONE;CIS_DATA_ADDRESS1 CIS_DATA_ADDRESS1 VISIBLE NONE;CIS_DATA_CITY CIS_DATA_CITY VISIBLE NONE;CIS_DATA_STATE CIS_DATA_STATE VISIBLE NONE;CIS_DATA_POSTAL CIS_DATA_POSTAL VISIBLE NONE;CIS_DATA_APN CIS_DATA_APN VISIBLE NONE;CIS_DATA_CU_XCOORD CIS_DATA_CU_XCOORD VISIBLE NONE;CIS_DATA_CU_YCOORD CIS_DATA_CU_YCOORD VISIBLE NONE;CIS_DATA_OP_AREA_CD CIS_DATA_OP_AREA_CD VISIBLE NONE")

# Create ABNCU XY Event Layer
arcpy.MakeXYEventLayer_management(ABNCU_view, "CIS_DATA.CU_XCOORD", "CIS_DATA.CU_YCOORD", ABNCU_XY, "PROJCS['NAD_1983_StatePlane_California_II_FIPS_0402_Feet',GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]],PROJECTION['Lambert_Conformal_Conic'],PARAMETER['False_Easting',6561666.666666666],PARAMETER['False_Northing',1640416.666666667],PARAMETER['Central_Meridian',-122.0],PARAMETER['Standard_Parallel_1',38.33333333333334],PARAMETER['Standard_Parallel_2',39.83333333333334],PARAMETER['Latitude_Of_Origin',37.66666666666666],UNIT['Foot_US',0.3048006096012192]];-115211800 -93821500 36983428.0573515;-100000 10000;-100000 10000;3.28083333333333E-03;0.001;0.001;IsHighPrecision", "")

# Copy Features ABNCU
arcpy.CopyFeatures_management(ABNCU_XY, ABNCU, "", "0", "0", "0")

# Create Query Table BIN
arcpy.MakeQueryTable_management("CIS_DATA", BIN_QUERY, "USE_KEY_FIELDS", "", "CIS_DATA.OBJECTID_1 #;CIS_DATA.OBJECTID #;CIS_DATA.FO_ID #;CIS_DATA.FA_ID #;CIS_DATA.CRE_DTTM #;CIS_DATA.SCHED_DT #;CIS_DATA.SCHED_TM #;CIS_DATA.DISP_GRP_CD #;CIS_DATA.FA_TYPE_CD #;CIS_DATA.INSTRUCTIONS #;CIS_DATA.DESCR254 #;CIS_DATA.REP_CD #;CIS_DATA.FO_STATUS_FLG #;CIS_DATA.WORK_DTTM #;CIS_DATA.EXTRACT_DTTM #;CIS_DATA.SP_ID #;CIS_DATA.PREM_ID #;CIS_DATA.ADDRESS1 #;CIS_DATA.CITY #;CIS_DATA.STATE #;CIS_DATA.POSTAL #;CIS_DATA.APN #;CIS_DATA.CU_XCOORD #;CIS_DATA.CU_YCOORD #;CIS_DATA.OP_AREA_CD #", "(SCHED_DT >= date '2017-03-02 00:00:00' AND SCHED_DT <= date '2017-03-31 00:00:00') AND (DISP_GRP_CD IN ('BINMAINT', 'DEL-CAN', 'RESBIN'))")

# Create BIN Table View
arcpy.MakeTableView_management(BIN_QUERY, BIN_View, "DISP_GRP_CD IN ('BINMAINT', 'DEL-CAN', 'RESBIN')", "", "CIS_DATA_OBJECTID_1 CIS_DATA_OBJECTID_1 VISIBLE NONE;CIS_DATA_OBJECTID CIS_DATA_OBJECTID VISIBLE NONE;CIS_DATA_FO_ID CIS_DATA_FO_ID VISIBLE NONE;CIS_DATA_FA_ID CIS_DATA_FA_ID VISIBLE NONE;CIS_DATA_CRE_DTTM CIS_DATA_CRE_DTTM VISIBLE NONE;CIS_DATA_SCHED_DT CIS_DATA_SCHED_DT VISIBLE NONE;CIS_DATA_SCHED_TM CIS_DATA_SCHED_TM VISIBLE NONE;CIS_DATA_DISP_GRP_CD CIS_DATA_DISP_GRP_CD VISIBLE NONE;CIS_DATA_FA_TYPE_CD CIS_DATA_FA_TYPE_CD VISIBLE NONE;CIS_DATA_INSTRUCTIONS CIS_DATA_INSTRUCTIONS VISIBLE NONE;CIS_DATA_DESCR254 CIS_DATA_DESCR254 VISIBLE NONE;CIS_DATA_REP_CD CIS_DATA_REP_CD VISIBLE NONE;CIS_DATA_FO_STATUS_FLG CIS_DATA_FO_STATUS_FLG VISIBLE NONE;CIS_DATA_WORK_DTTM CIS_DATA_WORK_DTTM VISIBLE NONE;CIS_DATA_EXTRACT_DTTM CIS_DATA_EXTRACT_DTTM VISIBLE NONE;CIS_DATA_SP_ID CIS_DATA_SP_ID VISIBLE NONE;CIS_DATA_PREM_ID CIS_DATA_PREM_ID VISIBLE NONE;CIS_DATA_ADDRESS1 CIS_DATA_ADDRESS1 VISIBLE NONE;CIS_DATA_CITY CIS_DATA_CITY VISIBLE NONE;CIS_DATA_STATE CIS_DATA_STATE VISIBLE NONE;CIS_DATA_POSTAL CIS_DATA_POSTAL VISIBLE NONE;CIS_DATA_APN CIS_DATA_APN VISIBLE NONE;CIS_DATA_CU_XCOORD CIS_DATA_CU_XCOORD VISIBLE NONE;CIS_DATA_CU_YCOORD CIS_DATA_CU_YCOORD VISIBLE NONE;CIS_DATA_OP_AREA_CD CIS_DATA_OP_AREA_CD VISIBLE NONE")

# Create BIN XY Event Layer
arcpy.MakeXYEventLayer_management(BIN_View, "CIS_DATA.CU_XCOORD", "CIS_DATA.CU_YCOORD", BIN_XY, "PROJCS['NAD_1983_StatePlane_California_II_FIPS_0402_Feet',GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]],PROJECTION['Lambert_Conformal_Conic'],PARAMETER['False_Easting',6561666.666666666],PARAMETER['False_Northing',1640416.666666667],PARAMETER['Central_Meridian',-122.0],PARAMETER['Standard_Parallel_1',38.33333333333334],PARAMETER['Standard_Parallel_2',39.83333333333334],PARAMETER['Latitude_Of_Origin',37.66666666666666],UNIT['Foot_US',0.3048006096012192]];-115211800 -93821500 36983428.0573515;-100000 10000;-100000 10000;3.28083333333333E-03;0.001;0.001;IsHighPrecision", "")

# Copy Features BIN
arcpy.CopyFeatures_management(BIN_XY, BIN, "", "0", "0", "0")

# Create Query Table APPEW
arcpy.MakeQueryTable_management("CIS_DATA", APPEW_QUERY, "USE_KEY_FIELDS", "", "CIS_DATA.OBJECTID_1 #;CIS_DATA.OBJECTID #;CIS_DATA.FO_ID #;CIS_DATA.FA_ID #;CIS_DATA.CRE_DTTM #;CIS_DATA.SCHED_DT #;CIS_DATA.SCHED_TM #;CIS_DATA.DISP_GRP_CD #;CIS_DATA.FA_TYPE_CD #;CIS_DATA.INSTRUCTIONS #;CIS_DATA.DESCR254 #;CIS_DATA.REP_CD #;CIS_DATA.FO_STATUS_FLG #;CIS_DATA.WORK_DTTM #;CIS_DATA.EXTRACT_DTTM #;CIS_DATA.SP_ID #;CIS_DATA.PREM_ID #;CIS_DATA.ADDRESS1 #;CIS_DATA.CITY #;CIS_DATA.STATE #;CIS_DATA.POSTAL #;CIS_DATA.APN #;CIS_DATA.CU_XCOORD #;CIS_DATA.CU_YCOORD #;CIS_DATA.OP_AREA_CD #", "(SCHED_DT >= date '2017-03-02 00:00:00' AND SCHED_DT <= date '2017-03-31 00:00:00') AND (FA_TYPE_CD = 'NCU-APEW')")

# APPEW Table View
arcpy.MakeTableView_management(APPEW_QUERY, APPEW_View, "FA_TYPE_CD = 'NCU-APEW'", "", "CIS_DATA_OBJECTID_1 CIS_DATA_OBJECTID_1 VISIBLE NONE;CIS_DATA_OBJECTID CIS_DATA_OBJECTID VISIBLE NONE;CIS_DATA_FO_ID CIS_DATA_FO_ID VISIBLE NONE;CIS_DATA_FA_ID CIS_DATA_FA_ID VISIBLE NONE;CIS_DATA_CRE_DTTM CIS_DATA_CRE_DTTM VISIBLE NONE;CIS_DATA_SCHED_DT CIS_DATA_SCHED_DT VISIBLE NONE;CIS_DATA_SCHED_TM CIS_DATA_SCHED_TM VISIBLE NONE;CIS_DATA_DISP_GRP_CD CIS_DATA_DISP_GRP_CD VISIBLE NONE;CIS_DATA_FA_TYPE_CD CIS_DATA_FA_TYPE_CD VISIBLE NONE;CIS_DATA_INSTRUCTIONS CIS_DATA_INSTRUCTIONS VISIBLE NONE;CIS_DATA_DESCR254 CIS_DATA_DESCR254 VISIBLE NONE;CIS_DATA_REP_CD CIS_DATA_REP_CD VISIBLE NONE;CIS_DATA_FO_STATUS_FLG CIS_DATA_FO_STATUS_FLG VISIBLE NONE;CIS_DATA_WORK_DTTM CIS_DATA_WORK_DTTM VISIBLE NONE;CIS_DATA_EXTRACT_DTTM CIS_DATA_EXTRACT_DTTM VISIBLE NONE;CIS_DATA_SP_ID CIS_DATA_SP_ID VISIBLE NONE;CIS_DATA_PREM_ID CIS_DATA_PREM_ID VISIBLE NONE;CIS_DATA_ADDRESS1 CIS_DATA_ADDRESS1 VISIBLE NONE;CIS_DATA_CITY CIS_DATA_CITY VISIBLE NONE;CIS_DATA_STATE CIS_DATA_STATE VISIBLE NONE;CIS_DATA_POSTAL CIS_DATA_POSTAL VISIBLE NONE;CIS_DATA_APN CIS_DATA_APN VISIBLE NONE;CIS_DATA_CU_XCOORD CIS_DATA_CU_XCOORD VISIBLE NONE;CIS_DATA_CU_YCOORD CIS_DATA_CU_YCOORD VISIBLE NONE;CIS_DATA_OP_AREA_CD CIS_DATA_OP_AREA_CD VISIBLE NONE")

# APPEW XY Event Layer
arcpy.MakeXYEventLayer_management(APPEW_View, "CIS_DATA.CU_XCOORD", "CIS_DATA.CU_YCOORD", APPEW_XY, "PROJCS['NAD_1983_StatePlane_California_II_FIPS_0402_Feet',GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]],PROJECTION['Lambert_Conformal_Conic'],PARAMETER['False_Easting',6561666.666666666],PARAMETER['False_Northing',1640416.666666667],PARAMETER['Central_Meridian',-122.0],PARAMETER['Standard_Parallel_1',38.33333333333334],PARAMETER['Standard_Parallel_2',39.83333333333334],PARAMETER['Latitude_Of_Origin',37.66666666666666],UNIT['Foot_US',0.3048006096012192]];-115211800 -93821500 36983428.0573515;-100000 10000;-100000 10000;3.28083333333333E-03;0.001;0.001;IsHighPrecision", "")

# Copy Features APPEW
arcpy.CopyFeatures_management(APPEW_XY, APPEW, "", "0", "0", "0")

# Create Query Table KICKS
arcpy.MakeQueryTable_management("CIS_DATA", KICKS_QUERY, "USE_KEY_FIELDS", "", "CIS_DATA.OBJECTID_1 #;CIS_DATA.OBJECTID #;CIS_DATA.FO_ID #;CIS_DATA.FA_ID #;CIS_DATA.CRE_DTTM #;CIS_DATA.SCHED_DT #;CIS_DATA.SCHED_TM #;CIS_DATA.DISP_GRP_CD #;CIS_DATA.FA_TYPE_CD #;CIS_DATA.INSTRUCTIONS #;CIS_DATA.DESCR254 #;CIS_DATA.REP_CD #;CIS_DATA.FO_STATUS_FLG #;CIS_DATA.WORK_DTTM #;CIS_DATA.EXTRACT_DTTM #;CIS_DATA.SP_ID #;CIS_DATA.PREM_ID #;CIS_DATA.ADDRESS1 #;CIS_DATA.CITY #;CIS_DATA.STATE #;CIS_DATA.POSTAL #;CIS_DATA.APN #;CIS_DATA.CU_XCOORD #;CIS_DATA.CU_YCOORD #;CIS_DATA.OP_AREA_CD #", "(SCHED_DT >= date '2017-03-02 00:00:00' AND SCHED_DT <= date '2017-03-31 00:00:00') AND (FA_TYPE_CD IN ('KICK', 'MISS', 'SUPERVSR'))")

# Create KICKS Table View
arcpy.MakeTableView_management(KICKS_QUERY, KICKS_View, "FA_TYPE_CD IN ('KICK', 'MISS', 'SUPERVSR')", "", "CIS_DATA_OBJECTID_1 CIS_DATA_OBJECTID_1 VISIBLE NONE;CIS_DATA_OBJECTID CIS_DATA_OBJECTID VISIBLE NONE;CIS_DATA_FO_ID CIS_DATA_FO_ID VISIBLE NONE;CIS_DATA_FA_ID CIS_DATA_FA_ID VISIBLE NONE;CIS_DATA_CRE_DTTM CIS_DATA_CRE_DTTM VISIBLE NONE;CIS_DATA_SCHED_DT CIS_DATA_SCHED_DT VISIBLE NONE;CIS_DATA_SCHED_TM CIS_DATA_SCHED_TM VISIBLE NONE;CIS_DATA_DISP_GRP_CD CIS_DATA_DISP_GRP_CD VISIBLE NONE;CIS_DATA_FA_TYPE_CD CIS_DATA_FA_TYPE_CD VISIBLE NONE;CIS_DATA_INSTRUCTIONS CIS_DATA_INSTRUCTIONS VISIBLE NONE;CIS_DATA_DESCR254 CIS_DATA_DESCR254 VISIBLE NONE;CIS_DATA_REP_CD CIS_DATA_REP_CD VISIBLE NONE;CIS_DATA_FO_STATUS_FLG CIS_DATA_FO_STATUS_FLG VISIBLE NONE;CIS_DATA_WORK_DTTM CIS_DATA_WORK_DTTM VISIBLE NONE;CIS_DATA_EXTRACT_DTTM CIS_DATA_EXTRACT_DTTM VISIBLE NONE;CIS_DATA_SP_ID CIS_DATA_SP_ID VISIBLE NONE;CIS_DATA_PREM_ID CIS_DATA_PREM_ID VISIBLE NONE;CIS_DATA_ADDRESS1 CIS_DATA_ADDRESS1 VISIBLE NONE;CIS_DATA_CITY CIS_DATA_CITY VISIBLE NONE;CIS_DATA_STATE CIS_DATA_STATE VISIBLE NONE;CIS_DATA_POSTAL CIS_DATA_POSTAL VISIBLE NONE;CIS_DATA_APN CIS_DATA_APN VISIBLE NONE;CIS_DATA_CU_XCOORD CIS_DATA_CU_XCOORD VISIBLE NONE;CIS_DATA_CU_YCOORD CIS_DATA_CU_YCOORD VISIBLE NONE;CIS_DATA_OP_AREA_CD CIS_DATA_OP_AREA_CD VISIBLE NONE")

# Create KICKS XY Event Layer
arcpy.MakeXYEventLayer_management(KICKS_View, "CIS_DATA.CU_XCOORD", "CIS_DATA.CU_XCOORD", KICKS_XY, "PROJCS['NAD_1983_StatePlane_California_II_FIPS_0402_Feet',GEOGCS['GCS_North_American_1983',DATUM['D_North_American_1983',SPHEROID['GRS_1980',6378137.0,298.257222101]],PRIMEM['Greenwich',0.0],UNIT['Degree',0.0174532925199433]],PROJECTION['Lambert_Conformal_Conic'],PARAMETER['False_Easting',6561666.666666666],PARAMETER['False_Northing',1640416.666666667],PARAMETER['Central_Meridian',-122.0],PARAMETER['Standard_Parallel_1',38.33333333333334],PARAMETER['Standard_Parallel_2',39.83333333333334],PARAMETER['Latitude_Of_Origin',37.66666666666666],UNIT['Foot_US',0.3048006096012192]];-115211800 -93821500 36983428.0573515;-100000 10000;-100000 10000;3.28083333333333E-03;0.001;0.001;IsHighPrecision", "CIS_DATA.CU_YCOORD")

# Copy Features KICKS
arcpy.CopyFeatures_management(KICKS_XY, KICKS, "", "0", "0", "0")

