# Final Programming Project - GEOG 375
# Created by: Katie Miller
#             
# Created on: 03.20.2016
# Submitted on: 05.15.2016
# Copyright:  2016

'''
This script will process well location data exported from the database
and convert into .kml format to use in Google Earth for project planning.
New fields will be added to further identify the well location in relation to specific locations.
The final process will export the file into .kml format to be emailed out to team members.

This script demonstrates:
1. Workspaces
2. Input and output feature classes
4. Use of ArcGIS geoprocessing fuctions
4. try: except: for error handling
'''
# 1. Import arcpy module
import arcpy, sys, traceback
                              
# 2. Create workspace
arcpy.env.workspace = "H:\\TestHOME\\"

# 3. Create variable definitions for geoprocessing functions
outpath = 'H:\\TestHOME\\MyData\\'
outpathGE = 'H:\\TestHOME\\GoogEarth\\'
dataset = "AWP_MAY122016_ORIGINAL.shp"
dataset_layer = "AWP_layer"
out_dataset = outpath + 'AWP_05122016_prj.shp'
out_coord = outpath + 'AWP_05122016_coord.shp'
sup_dist = outpath + 'SUPERVISOR_DISTRICTS.shp'
data_correction = outpath + 'NeedCorrection.shp'
spatialref = arcpy.SpatialReference('NAD 1983 StatePlane California II FIPS 0402 (US Feet)')
mxd = MapDocument(outpath + 'AWP.mxd')
fieldName1 = "SUP_DIST"
fieldName2 = "SOURCE"

try:

# 4. Define projection for GIS data export
    arcpy.DefineProjection_management(dataset, spatialref)
    print "Define Projection"
    
# 5. Project GIS data export
    # check to see if feature class already exists
    # if it does, delete it
    if arcpy.Exists(out_dataset):
        arcpy.Delete_management(out_dataset)

    arcpy.Project_management (dataset, out_dataset, spatialref)
    print "Data Projected to NAD 1983 StatePlane California II FIPS 0402 (US Feet)"
    
# 6. Convert Coordinate Notation to display data
    # check to see if feature class already exists
    # if it does, delete it
    if arcpy.Exists(out_coord):
        arcpy.Delete_management(out_coord)

    arcpy.ConvertCoordinateNotation_management (out_dataset, out_coord, "Longitude", "Latitude", "DD_2", "DD_2")                  

    result = arcpy.GetCount_management (out_coord)
    print "Number of features in the feature class " + out_coord + " : " + str(result)

# 7. Get the map document: used for data query and select by location
    mxd = MapDocument(outpath + 'AWP.mxd')

    # Get a list of data frames
    dataframe = ListDataFrames(mxd, "Layers") [0]

    # Get a List of layers in the table of contents of the map document
    TOCLayers = ListLayers (mxd)
    
# 8. Identify any well points that fall outside of the county boundary and export them for correction, then delete them from the dataset

    # Make a feature layer for AWP_MAY122016_ORIGINAL
    # make the feature layer from the feature class
    arcpy.MakeFeatureLayer_management(out_coord, dataset_layer)

    # select by location points that are within county boundary, switch selection, export, delete records
    arcpy.SelectLayerByLocation_management(dataset_layer, 'intersect', 'SacCounty_COUNTY_BOUNDARY.shp')
    result = arcpy.GetCount_management(dataset_layer)
    count = int(result.getOutput(0))
    print 'Well points within county: ' + str(count)

    # switch selected to export points that don't intersect the county boundary
    arcpy.SelectLayerByAttribute_management(dataset_layer,'SWITCH_SELECTION')
    result = arcpy.GetCount_management(dataset_layer)
    count = int(result.getOutput(0))
    print 'Well points out of county: ' + str(count)

    # write the selected features to a new featureclass
    # check to see if feature class already exists
    # if it does, delete it
    if arcpy.Exists(data_correction):
        arcpy.Delete_management(data_correction)
    arcpy.CopyFeatures_management(dataset_layer, data_correction)
    print "Well points out of county exported for correction and removed from dataset"

    #delete selected points
    arcpy.DeleteFeatures_management(dataset_layer)
    arcpy.SelectLayerByAttribute_management(dataset_layer, 'CLEAR_SELECTION')
    
# 9. Add fields to the attribute table (Supervisor District, Source)
    arcpy.AddField_management(dataset_layer, fieldName1, "TEXT", "", "", 3)
    arcpy.AddField_management(dataset_layer, fieldName2, "TEXT", "", "", 5)
    print 'Added new fields: Supervisor District and Source'
    
# 10. Select by Location and use field calculator to fill in newly added fields
''' This part still needs some work to figure out, I wanted to select each supervisor district,
    then select by location wells that are in that supervisor district, then use field calculator
    to fill the information into the "SUP_DIST" field. My other option is to use Spatial Join
    ######################arcpy.MakeFeatureLayer_management(sup_dist, sup_dist_lyr)
    ######arcpy.SelectLayerByAttribute_management("SUPERVISOR_DISTRICTS_sde.lyr", "NEW_SELECTION", " [DIST] = '1' ")
    #######arcpy.SelectLayerByLocation_management(dataset_layer, 'intersect', 'SUPERVISOR_DISTRICTS.shp')
    ##########arcpy.CalculateField_management(dataset_layer, "1")'''
    
                                           
# 11. Import symbology from previously made layer
    # Access mxd and import symbology - will be added in the future

# 12. Export wells to .kml for use in Google Earth to mail out to the team
    if arcpy.Exists("AWP_MAY122016.kmz"):
        arcpy.Delete_management("AWP_MAY122016.kmz")
    arcpy.LayerToKML_conversion(dataset_layer, "AWP_MAY122016.kmz")


    print "AWP data process complete, new Google Earth file created"
    
except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)



