# Finnell Final Project
# Created by: Micheal Finnell
#             michealfinnell@gmail.com
# Created on: 05.13.2016
# Updated on: 05.15.2015





import arcpy, sys, os,traceback, datetime
from arcpy.mapping import *   # Eliminates the need to write arcpy.mapping
                              # before each mapping module related class, function
                              # or method
print "good"
# Reformat date to MM.DD.YYYY
# NOTE: lowercase %y will result in MM.DD.YY format

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')
print "good"

try:

    # Get the map document
    # Custom template set up for map production
    # Paths to match the location of data and folders
    
    datapath = 'C:\\Users\\Micheal\\Desktop\\2015BeeGIS\\'
    mappath = datapath + 'Bee_PDFs\\' # this will be the output folder for PDFs.
    mxd = MapDocument(datapath + 'Beemap.mxd')
    print "data path good"

    # Get a list of layers in the table of contents of the map document
    TOCLayers = ListLayers(mxd) 

    # loop through the layers
    for TOCLayer in TOCLayers:
        print 'Layer Name: ' + str(TOCLayer.name)#Printing the List of Layers in the Dataframes
        if TOCLayer.name == 'Bombus ssp.':#while looping if the layer name is found then the script will turn on this layer in the TOC
            TOCLayer.visible = True
            if TOCLayer.name == 'Bombus vosnesenskii' or\ #
                TOCLayer.name == 'Bombus vandykei' or\    #
                TOCLayer.name == 'Bombus flavifrons' or\  #Not particularly certain that this segment works as I started
                TOCLayer.name == 'Bombus californicus':   #with no layers except base layers turned on
                TOCLayer.visible = False                  #

        arcpy.RefreshTOC()
        arcpy.RefreshActiveView()#added these two commands to refresh the TOC and View
    if arcpy.Exists(mappath + 'Tot_ssp.pdf'):#if this PDF exists...
        arcpy.Delete_management(mappath + 'Tot_ssp.pdf')#then script will delete
         
    ExportToPDF(mxd, mappath + 'Tot_ssp.pdf')

    #Second loop to turn off last visible layer, then to turn on the next
    for TOCLayer in TOCLayers:
        
        if TOCLayer.name == 'Bombus ssp.':
            TOCLayer.visible = False
        
        elif TOCLayer.name == 'Bombus vosnesenskii':
            TOCLayer.visible = True
           
        elif TOCLayer.name == 'Bombus vandykei' or\
            TOCLayer.name == 'Bombus flavifrons' or\ #again I feel like this segment does not work,
            TOCLayer.name == 'Bombus californicus':  #because if I turn on all bee layers it doesn't turn them off
            TOCLayer.visible = False

        arcpy.RefreshTOC()
        arcpy.RefreshActiveView()
    if arcpy.Exists(mappath + 'B_vos.pdf'):
        arcpy.Delete_management(mappath + 'B_vos.pdf')
         
    ExportToPDF(mxd, mappath + 'B_vos.pdf')

    for TOCLayer in TOCLayers:
        
        if TOCLayer.name == 'Bombus vosnesenskii':
            TOCLayer.visible = False
        
        elif TOCLayer.name == 'Bombus vandykei':
            TOCLayer.visible = True
           
        elif TOCLayer.name == 'Bombus ssp.' or\
            TOCLayer.name == 'Bombus flavifrons' or\
            TOCLayer.name == 'Bombus californicus':
            TOCLayer.visible = False

        arcpy.RefreshTOC()
        arcpy.RefreshActiveView()
    if arcpy.Exists(mappath + 'B_van.pdf'):
        arcpy.Delete_management(mappath + 'B_van.pdf')
         
    ExportToPDF(mxd, mappath + 'B_van.pdf')

    for TOCLayer in TOCLayers:
        
        if TOCLayer.name == 'Bombus flavifrons':
            TOCLayer.visible = False
        
        elif TOCLayer.name == 'Bombus californicus':
            TOCLayer.visible = True
           
        elif TOCLayer.name == 'Bombus ssp.' or\
            TOCLayer.name == 'Bombus vosnesenskii' or\
            TOCLayer.name == 'Bombus vandykei':
            TOCLayer.visible = False

        arcpy.RefreshTOC()
        arcpy.RefreshActiveView()
    if arcpy.Exists(mappath + 'B_cal.pdf'):
        arcpy.Delete_management(mappath + 'B_cal.pdf')
         
    ExportToPDF(mxd, mappath + 'B_cal.pdf')
            
    # Print statement that reports the map docs were converted to PDF and complete
    print "Created All Species PDFs"

               
    
except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
