#Created By: William Edmonson
#Date: 4/21/2016
#Calculate Restaurants relationships to crime

#Import Modules
import arcpy, sys, traceback, os
from arcpy import env

arcpy.env.overwriteOutput = True

#Set Local Variables
Crimes = "C:\\Downtown_SAC\\crime_2010.shp"
Restaurants = "C:\\Downtown_SAC\\Downtown_Restaurants.shp"
Rest_Layer = "Rest_Layer"
Crimes_Layer = "Crimes_Layer"
Outpath = "C:\\Downtown_SAC\\Outputs\\"
Rest_Selection = Outpath + "Rest_Selection.shp"

#Create Feature Layers
print "Calculating Restaurant and crime Relationships...."

try:
    if arcpy.Exists(Rest_Layer):
        arcpy.Delete_Management(Rest_Layer)

    arcpy.MakeFeatureLayer_management(Restaurants, Rest_Layer)

    if arcpy.Exists(Crimes_Layer):
        arcpy.Delete_Management(Crimes_Layer)

    arcpy.MakeFeatureLayer_management(Crimes, Crimes_Layer)

#Create a Search Cursor to Select each individual restaurant and copy it to a new feature layer

    Rest_Layer
    with arcpy.da.SearchCursor(Rest_Layer, "Rest_Name", "", "", "", ("DISTINCT", "ORDER BY Rest_Name")) as Rest_Cursor:
        for Rest_Name in Rest_Cursor:
            query = """"Rest_Name" = '""" + Rest_Name[0] + """'"""
            arcpy.SelectLayerByAttribute_management(Rest_Layer, "NEW_SELECTION", query)
            if arcpy.Exists(Outpath + Rest_Name[0]):
                arcpy.Delete_Management(Outpath + Rest_Name[0])
            arcpy.CopyFeatures_management(Rest_Layer, Outpath + Rest_Name[0])
            

            if arcpy.Exists(Outpath + Rest_Name[0] + ".layer"):
                arcpy.Delete_Management(Outpath + Rest_Name[0] + ".layer")

            arcpy.MakeFeatureLayer_management(Outpath + Rest_Name[0] + ".shp", Outpath + Rest_Name[0] + ".layer")  

            
#Perform 400 ft buffer around each restaurant. 400 ft roughly represents 1 Block. 
#Create Buffer Variables
            Rest_Buff_Layer = Outpath + Rest_Name[0] + "_400ft_buff.layer" 
            Rest_Buff = Outpath + Rest_Name[0] + "_400ft_buff.shp"
            Buff_In = Outpath + Rest_Name[0] + ".shp"
            Buff_Dist = "400"
            Buff_Unit = "Feet"
            Buff_Layer = Outpath + Rest_Name[0] + "_400ft_buff.layer"
         

#Perform Buffer Analysis        
            arcpy.Buffer_analysis(Buff_In, Rest_Buff, Buff_Dist + " " + Buff_Unit)
   
            if arcpy.Exists(Rest_Buff_Layer):
                arcpy.Delete_Management(Rest_Buff_Layer)

#Create a Buffer Layer to be used in the Select by Location
#Select Crimes within the 400ft buffer
            arcpy.MakeFeatureLayer_management(Rest_Buff, Rest_Buff_Layer)


            arcpy.SelectLayerByLocation_management(Crimes_Layer, "WITHIN", Rest_Buff_Layer)

#Determine the number of crimes selected
            selection_count = int(arcpy.GetCount_management(Crimes_Layer)[0])

#Perform a Search Cursor to retrieve the Crime codes of the crimes within 400ft of the restaurant
#The if and else statements are used to print the number of crimes selected, the restaurant name,
#and the crime codes of selected crimes.
                 
            if selection_count == 0:
                print("There are no crimes witin 400ft of ") + (str(Rest_Name[0]) + ".")
            else:
                arcpy.CopyFeatures_management(Crimes_Layer, Outpath + Rest_Name[0] + "_crimes")
                print (str(selection_count) + " crime(s) are located within 400ft of " + str(Rest_Name[0] + "."))
                field_name = ["Code"]
                with arcpy.da.SearchCursor(Crimes_Layer, field_name) as CLrows:
                    for CLrow in CLrows:
                        CLName = CLrow[0]
                        print "The crime codes of these crimes are: " + str(CLName)
                
                                              
        

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)



    
