#Created By: William Edmonson
#Date: 4/21/2016
#Calculate Statistcs for a Neighboorhood

import arcpy, sys, traceback
from arcpy import env

arcpy.env.overwriteOutput = True


#Set local Variables
Crimes = "C:\\Downtown_SAC\\Outputs\\Crimes_Clip.shp"
outtable = "C:\\Downtown_SAC\\Outputs\\DT_Crime_Stats.dbf"
Neighborhood = "C:\\Downtown_SAC\\neigh_hd.shp"
DT_Query = """"NAME" = 'Downtown'""" 
NH_Layer = "NH_Layer"
Crimes_Layer = "Crimes_Layer"
DT_Crimes_Layer = "DT_Crimes_Layer"
StatsField = [["Sev_Code", "MEAN"]]
casefield = "Sev_Code"
DT_Crimes_fc = "C:\\Downtown_SAC\\Outputs\\DT_Crimes_fc.shp"
#Perform a Select Statement to Select the Downtown Neighborhood 
try:
    if arcpy.Exists(NH_Layer):
        arcpy.Delete_Management(NH_Layer)

    arcpy.MakeFeatureLayer_management(Neighborhood, NH_Layer)

    arcpy.SelectLayerByAttribute_management(NH_Layer, "NEW_SELECTION", DT_Query)
    

#Perform a Select By Location for Crimes in Downtown
    if arcpy.Exists(Crimes_Layer):
        arcpy.Delete_Management(Crimes_Layer)

    arcpy.MakeFeatureLayer_management(Crimes, Crimes_Layer)

    arcpy.SelectLayerByLocation_management(Crimes_Layer, "WITHIN", NH_Layer, "","NEW_SELECTION")
    
    

#Of those Crimes, determine the average Crime Severity Rating.
#This is done by using the Statistics Analysis function.
#The Crimes DT_Crimes_Layer will serve as the input table.

    print "Preparing to copy feature layer to feature class."
    
#Copy the newly selceted Crimes to a new Feature class.    
    arcpy.CopyFeatures_management(Crimes_Layer, DT_Crimes_fc)
    print "Feature Class Successfully created."

    print "Peforming Statistics Analysis.."
    arcpy.Statistics_analysis(DT_Crimes_fc, outtable, StatsField)

#Create a Search Cursor for outtable to print the results
    field_name = ["MEAN_Sev_C"]
    with arcpy.da.SearchCursor(outtable, field_name) as AVGrows:
        for AVGrow in AVGrows:
                  AVGcrime = AVGrow[0]

    result = arcpy.GetCount_management(Crimes_Layer)
    print "Statistics Analysis Complete."
    print "The total Number of Crimes within Downtown is = " + str(result)
    print "The average Severity Rating of a Crime in Downtown is = " + str(AVGcrime)
    
    
    
except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
