
# ---------------------------------------------------------------------------
# Created By: William Edmonson
# Created on: 2016-04-27 
# Description: Geocode Sacramento Restaurants
# ---------------------------------------------------------------------------

# Import arcpy module
import arcpy, sys, traceback
from arcpy import env

arcpy.env.overwriteOutput = True

# Local variables:
Rest_excel = "C:\\Downtown_SAC\\Restaurants.xlsx\\Sheet1$"
Sacramento_Locator = "C:\\Downtown_SAC\\Sacramento_Locator"
DT_Rest = "C:\\Downtown_SAC\\Outputs\\DT_Restaurants.shp"

# Process: Geocode Addresses
try:
    print "Executing Geocode Addresses"
        
    arcpy.GeocodeAddresses_geocoding(Rest_excel, Sacramento_Locator,\
                                     "'Single Line Input' Full_Address VISIBLE NONE", DT_Rest, "STATIC")

    print "Geocoding has successfully finished!"

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo\ + "\nError Info:\n\     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)

