#Extracting NDVI from MODIS Imagery
#and Other Pre-Processes
#by Michael Chenaille
#GEOG 375
#Spring 2017
#email: w1506674@apps.losrios.edu, michaelchenaille@live.com

import os, arcpy, datetime, traceback, sys
from arcpy import env                   #imports environments
from arcpy.sa import *                  #imports spatial analyst module

#allows outputs to be overwritten
arcpy.env.overwriteOutput=True


#Variables
in_ws = 'C:\\Users\\MChenaille\\Desktop\\MODIS\\Scratch\\'
out_pcs = arcpy.SpatialReference(26911) #This is the spatial reference for
                                        #NAD 1983 UTM Zone 11 N

try:

    arcpy.env.workspace = in_ws

    rasterList = arcpy.ListRasters('*.hdf')

    #Extract NDVI from the MODIS and truncate the file names
    #Name the files according to their tile number and unique date
    #With MODIS imagery 'Band 0' is NDVI, 'Band 1' is EVI, since I
    #am interested in NDVI, I extract band 0 using the 'Extract SubDataset Tool'
    #Save as a .tif instead of .hdf, because .tif is more universal raster extension
    for raster in rasterList:
        print 'Extracting NDVI from ' + str(raster)
        out = raster[8:16] + raster[17:23] + '_ndvi.tif'
        arcpy.ExtractSubDataset_management(raster, out, '0')

    #Project the rasters to NAD 1983 UTM Zone 11 N (Spatial Reference 26911)
    rasterList1 = arcpy.ListRasters()
    for raster in rasterList1:
        if raster.endswith('_ndvi.tif'):
            print 'Projecting raster for ' + str(raster)
            out_proj = str(raster[:-4]) + '_proj.tif'
            arcpy.ProjectRaster_management(raster, out_proj, out_pcs)

    #Use Extract by Mask to clip the rasters to the state of Nevada
    #Put them in specific subdirectories according to their unique dates
    #Each folder will contain 4 separate rasters, each will be a portion
    #of Nevada, to be mosaiced in a later step

    #Lists only rasters that both begin with 'A' and end with 'proj.tif'
    rasters = arcpy.ListRasters('A*_proj.tif')

    mask = 'C:\\Users\\MChenaille\\Desktop\\MODIS\\Scratch\\NEVADA.shp'

    samps = []
    for raster in rasters:
        samps.append(raster[0:8])

    sdirs = list(set(samps))

    #Here is where the aforementioned subdirectories are created, since the
    #directoreies are made in the same scratch folder as all the rasters,
    #both source rasters and intermediate ones, there are many folders which
    #start with 'M' for 'MODIS.' I do not want subdirectories with that name
    #so I used a boolean operator to exclude rasters that begin with the
    #letter 'M,' so then it will only create folders which begin with 'A'
    #followed directly by the julian date.
    for s in sdirs:
        if s[0] != 'M':     #This part is actually redundant now that I changed how the raster list is created above, but it's a safeguard
            os.makedirs(os.path.join('C:\\Users\\MChenaille\\Desktop\\MODIS\\Scratch\\', s))
            print 'Making subdirectory for julian date ' + str(s[1:8])
        else:
            print 'We don\'t need a folder with THAT name!'

    for dirs in os.walk(in_ws):
        for raster in rasters:
            outname = os.path.join(('C:\\Users\\MChenaille\\Desktop\\MODIS\\Scratch\\' + raster[0:8] + '\\'), (str(raster[:-4]) + '_mask.tif'))
    #I ended up using the 'Clip' tool (in data management) as opposed to
    #'Extract by Mask' (spatial analyst)because I had difficulty getting
    #'Extract by Mask' to work so I looked for other options, 'Clip' worked on
    #my first try so, because these two geoprocesses are virtually identical
    #and both result in acceptable products I just went with what was readily
    #working. I also was only interested in clipping rasters with the correct
    #spatial reference, so I used a conditional statement to select only
    #rasters with 'proj' in the name.
            if raster[20:24] == 'proj':
                extract = arcpy.Clip_management(raster, '#', outname, mask, '0', 'ClippingGeometry')
            else:
                print 'Not extracting ' + raster + ' because it is an older, intermediate step and has no business in this folder because it has an undesired spatial reference.'

    #Iterates through the directories made previously that contain the clipped,
    #projected NDVI rasters. It takes the contents of each separate folder and
    #mosaics them together using the 'Mosaic to New Raster' tool. 
    for sdir in sdirs:
        arcpy.env.workspace = os.path.join('C:\\Users\\MChenaille\\Desktop\\MODIS\\Scratch\\', sdir)
        rasterlist = arcpy.ListRasters('*.tif')
        arcpy.MosaicToNewRaster_management(rasterlist, 'C:\\Users\\MChenaille\\Desktop\\MODIS\\Mosaics', (sdir + '_' + 'mosaic.tif'), '#', '16_BIT_SIGNED', '#', '1', '#', '#')
       
except:
    print 'Failed! Here is why: '
    traceback.print_exc()
#Special thank you to my coworker Cali Roth for helping me troubleshoot, especially with
#the creation of the sub-directories. Also StackExchange is a god-send.
