# Created by:  Bryan Zhou
# Created on:  04.04.2014
# Updated on:  05.16.2014

'''
This script is intended for groundwater data (comma-delimited text file)
from the Texas Water Development Board.  The Insert Cursor is used
to add data retrieved from the text file into a empty well feature class

Reference

Source: Programming ArcGIS 10.1 with Python Cookbook
.

'''

import arcpy, sys, os, traceback

# Create workspace

arcpy.env.workspace = "C:\\Hale_Texas\\Data\\"

# Create variable definitions for geoprocessing functions

well = "C:\\Hale_Texas\\Data\\Hale.gdb\\Well"

try:
    # Open the comman-delimited text file containing the well data and read all the lines into a list:

    f = open("C:\\Hale_Texas\\Data\\Hale_wells.txt","r")
    Aqua = f.readlines()

    # Create a query for fields in well 

    fields = ["HydroCode", "SHAPE@XY", "AquiferCode", "LandElev", "FType", "WellDepth"]

    # Create a Insert cursor to add well data from the a text file into an empty point feature class

    with arcpy.da.InsertCursor(well, fields) as wrows:

        cntr = 1 # counter variables to initialize the loop

        for row in Aqua:
            
            if "state_well_number" in row: # check to see if the variable exists
                
                continue
            
            hydro = row.split(",")  # separate each list into separate variables
            state = str(hydro[0])        # pull out the individual items and assign them a variable
            Latitude = float(hydro[1])
            Longitude = float(hydro[2])
            aquifer = long(hydro[3])
            Elev = float(hydro[4])
            well_type = str(hydro[5])
            well_depth = str(hydro[6])

            if well_depth is '': # Check for missing data

                well_depth = None

            if well_depth != '':
                Values = [state, (Longitude, Latitude), aquifer, Elev, well_type, well_depth]
                wrows.insertRow(Values)
                cntr = cntr + 1   #add new row with counter

            print "Record Number" + str(cntr - 1) + well
            f.close()
      
except:

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)          
                             
