# Created by:  Bryan Zhou
# Created on:  04.04.2014
# Updated on:  05.16.2014

'''
This script is intended for ArcHydro Groundwater. The Correct verison of
ArcHydro Groundwater must be installed for ArcGIS 10.1. The software can be
downloaded at www.aquaveo.com.  This script demonstrate the use of 
Join, Calculate Field, and Select layer by Attribute.
Source: http://resources.arcgis.com/en/help/main/10.1/index.html#//009t00000004000000

'''

import arcpy, sys, os, traceback

# Create workspace

arcpy.env.workspace = "C:\\Hale_Texas\\Data\\Hale.gdb"

# Create variable definitions for geoprocessing functions

County = "Counties"
Clayer = "County_lyr"
well = "Well"  # point feature class
wells = "Well_Tv" # Table view of the well feature class
Tview = "Tseries_Tv" # Table view of Time Series table
Tinfo = "TimeSeries" # Time Series table
Hale = "Hale"

try: # Check to see if well feature layer exists and delete it

    if arcpy.Exists(wells):
        arcpy.Delete_management(wells)

    # Create the well table view

    arcpy.MakeTableView_management(well, wells) 

    # Calculate the value for HydroID

    arcpy.CalculateField_management(wells, "HydroID", "!Hydrocode!", "PYTHON")

    print "Field Calculated"
    
    # Check to see if Tview exists and delete it

    if arcpy.Exists(Tview):
        arcpy.Delete_management(Tview)

    # Create a Table view for TimeSEries1

    arcpy.MakeTableView_management(Tinfo, Tview)

    # Calculate the value for the VarID

    arcpy.CalculateField_management(Tview, "VarID", "1", "PYTHON")

    print "Field Calculated"

    # Perform a join operation with TimeSeries table and the well feature class
    #Get a list of indexes and remove them

    indexes = arcpy.ListIndexes(well)
    
    for index in indexes:
        
        if (index.name == 'Well_Index'):
            arcpy.RemoveIndex_management(well, 'Well_Index')

    indexes = arcpy.ListIndexes(Tinfo)   # list the indexes for the Tinfo
    
    for index in indexes:

        if (index.name == 'Table_Index'):
            arcpy.RemoveIndex_management(Tinfo, 'Table_Index')

       # Create the index for the well layer and the TimeSeries table view
    
    arcpy.AddIndex_management(well, 'HydroID', 'Well_Index', 'NON_UNIQUE', 'NON_ASCENDING')
    arcpy.AddIndex_management(Tinfo, 'FeatureID', 'Table_Index', 'NON_UNIQUE', 'NON_ASCENDING')

    print "Create Index"

    # Perform the join operation

    arcpy.AddJoin_management(Tview, 'FeatureID', wells, 'HydroID', "KEEP_ALL")

    print "Joined was Sucessful"

    # Calculate the actual elevation

    arcpy.CalculateField_management(Tview, "TsValue_normalized", "!Well.LandElev!" + "!TimeSeries.TsValue!","PYTHON")

    print "Field Calculated"
    
    # Remove the Join

    arcpy.RemoveJoin_management(Tview)

    # Create the Hale County feature Class using the Select By Attribute and the clip tool.
    # Create a query statement to select Hale County.

    query = '"NAME" = \'Hale\''

    # Create a feature layer for Counties

    if arcpy.Exists(Clayer):
        arcpy.Delete_management(Clayer)

    arcpy.MakeFeatureLayer_management(County, Clayer)

    # Select the Hale County from Counties
    
    arcpy.SelectLayerByAttribute_management(Clayer, "NEW_SELECTION", query)

    # Check to see if Hale County exists in the GDB

    if arcpy.Exists(Hale):
        arcpy.Delete_management(Hale)

    # 10.  Copy the selected County to a new feature class

    arcpy.CopyFeatures_management(Clayer, Hale)

    print "finished"
    
except:

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)          
                             
