# Created by:  Bryan Zhou
# Created on:  04.04.2014
# Updated on:  05.16.2014

'''
This script is intended for groundwater data (tab delimited text file)
from the Texas Water Development Board.  The Insert Cursor is used
to add data retrieved from the text file into empty table.

Reference

Source: Programming ArcGIS 10.1 with Python Cookbook
'''

import arcpy, sys, os, traceback

# Create workspace

arcpy.env.workspace = "C:\\Hale_Texas\\Data"

# Create variable definitions for geoprocessing functions

Stime = "C:\\Hale_Texas\\Data\\Hale.gdb\\TimeSeries"
Tseries = ("FeatureID", "TsValue", "TsTime")
state = "state_well_number"
Date_Time = "Date_Time"
Month = "mm_date"
Day = "dd_date"
Year = "yy_date"



try:

    # Open the tab-delimited text file containg water level data and read all the lines into a list:

    Z = open("C:\\Hale_Texas\\Data\\Data\\Hale_water.txt","r")
    trows = Z.readlines()

    # Create a insert cursor object to add water level data to the Time Series table

    with arcpy.da.InsertCursor(Stime, Tseries) as srows:

        Cntr = 1 

        for trow in trows:

            if "state_well_number" in trow:
            
                continue

        H20 = trow.split('/t') # Create a variable to separate the list

        state = str(H20[0]) # Create variables to hold the field
        depth_from_lsd = float(H20[1])
        Month = str(H20[2])
        Day = str(H20[3])
        Year = str(H20[4])
        Date_Time = str(H20[5])

        if Month is 0:  # Fix the month values
            Month = 1
            
        if Day is 0: # Fix the Day values
            Day = 1
            
        if Depth is '': 
            Depth = None

        if Depth != '':

            New_value = [state, Depth, Date_Time]

            srows.insertRow(New_value)
            Cntr = Cntr + 1
            print Month + "/" + Day + "/" + Year
            print "Written to Feature" + str(Cntr-1) + Stime

    Z.close()

    
except:

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)          
                             
