# Created by:  Laurel Warddrip
# Created on:  3.27.2015

'''
NOTES: writing code for impaired water body model to use python

'''
#Import arcpy, sys, traceback
#Create workspace
#Create variable definitions
#Build A Query
#Create and Use a Feature Layer
#Select Data by Location
#Counting Records
#Creating a feature class
#Creating a standalone table
#Add try: and except: blocks
#Use of import and traceback blocks 

# import the required modules for the python script

import arcpy, sys, traceback

# create workspace, you will need to change this where you store the GDB
# QUESTION FOR Jeff: tried everything to get the files to load // and \\ and / keep getting ERROR 000732 - could it be the computer and administr rights?

arcpy.env.workspace = "E:\impaired2015\imb2015\impaired_igp_gdb.gdb"

# Local variables: 

hpoly_fc = "HucTen.shp"

hpoly_layer = "Huc10_Poly"

point_fc = "point_sel.shp"

point_layer = "point_sel_layer"

imp_line_fc = 'T2010_303d_EPAapr_lines121211'

imp_line_layer = "imp_l_layer"

imp_poly_fc = 'T2010_303d_EPAapr_poly121211'

imp_poly_layer = "imp_p_layer"

out_imp_fc = "out_imp.shp"

out_imp_attributes = "out_imp_attrib.dbf"


# add try block
try:
         
    # make a feature layer and check to see if the feature layer exists; if so, delete it for Huc 10, LA facilties, impairments
    if arcpy.Exists(hpoly_layer):
        arcpy.Delete_management(hpoly_layer)
        
    arcpy.MakeFeatureLayer_management(hpoly_fc, hpoly_layer)
    if arcpy.Exists(point_layer):
        arcpy.Delete_management(point_layer)
        
    arcpy.MakeFeatureLayer_management(point_fc, point_layer)

    if arcpy.Exists(imp_line_layer):
        arcpy.Delete_management(imp_line_layer)
        
    arcpy.MakeFeatureLayer_management(imp_line_fc, imp_line_layer)

    if arcpy.Exists(imp_poly_layer):
        arcpy.Delete_management(imp_poly_layer)
        
    arcpy.MakeFeatureLayer_management(imp_poly_fc, imp_poly_layer)

    # Script arguments
    point_sel = arcpy.GetParameterAsText(0)
    if point_sel == '#' or not point_fc:
        point_fc = "in_memory\\{EB8B65FD-D5B5-4031-BF2A-84480949E895}" # provide a default value if unspecified
    
    #select by location: (in_layer, overlap_type, select_features, search_distance, selection_type)

         
    #arcpy.SelectLayerByLocation_management(X_layer, "CONTAINED_BY", X_layer, "NEW_SELECTION")

    arcpy.SelectLayerByLocation_management (hpoly_layer, "CONTAINS", point_layer, "", "NEW_SELECTION")
    arcpy.SelectLayerByLocation_management(imp_poly_layer, "INTERSECT", hpoly_layer, "", "SUBSET_SELECTION")
    arcpy.SelectLayerByLocation_management(imp_line_layer, "WITHIN", hpoly_layer, "", "SUBSET_SELECTION")
    print "Number of features in the feature layer " + imp_line_layer + imp_poly_layer + "\n within LOCAL CLASS " + ": "+ str(result)

    # selected lines write to SHP file and copy selected features to the new SHP
    if arcpy.Exists(out_imp_fc):
        arcpy.Delete_management(out_imp_fc)
    arcpy.CopyFeatures_management(imp_poly_layer, out_neigh_fc)
    arcpy.CopyFeatures_mangement(imp_line_layer, out_imp_fc)
    print "Copied selected features from " + imp_line_layer + imp_poly_layer + " to " + out_imp_fc

    #write out selected imparments to a standalone table that is new

    if arcpy.Exists(out_imp_attributes):
        arcpy.Delete_management(out_imp_attributes)
    arcpy.CopyRows_management (imp_line_layer, out_imp_attributes)
    arcpy.CopyRows_management (imp_poly_layer, out_imp_attributes)
    print "Copied selected attributes from " + imp_poly_layer + imp_line_layer +" to " + out_imp_attributes
    
        
except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
