# Final Project (Geocode Address Diaplay) - Outline of steps

# Created by: Takeo Shibata
# Created on: 04.16.2014
# Updated on: 05.02.2014
# Copyright:  2014
'''
This script read the information from relational database and create CSV files.
Then geocode the address using Bing gecocoding service and write back to XY information to the database.
Then load the XY onto the point layer and diplay those in the base map
In addition, The delivery route is created using route service from Bing with realtime traffic
'''

#Import standard/necessary library modules
import arcpy, sys, os, string, traceback, psycopg2, urllib, urllib2, json, datetime, time
from arcpy.mapping import *

# Check out the Spatial Analysis Extension

#Set the input/output workspace
arcpy.env.workspace ='C:\\EsriPress\\GIST1\\PythonPrimer\\Project\\FP\\'

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

#Set the database information either using default set or get input by prompt
#This will be more like System Admin Setting info
dbhost = raw_input('Database host or IP address[Default:192.168.10.59]>')
if len(dbhost) == 0:
    dbhost = '192.168.10.59'   
dbname = raw_input('Database Name[Default:arcpyproj]>')
if len(dbname) == 0:
    dbname = 'arcpyproj'
dbuser = raw_input('Database User[Default:postgres]>')
if len(dbuser) == 0:
    dbuser = 'postgres'
dbpass = raw_input('Database Password[Default:Pass123]>')
if len(dbpass) == 0:
    dbpass = 'Pass123'

#Get the delivery assignemt ID by imput or default
AssignID = raw_input('Enter Your Delievry Assignment ID [Example:34345567]>')
if len(AssignID) == 0:
    AssignID = '34345567'

#Set Warehouse Lat and Long

wh_lat = 33.9125823975
wh_long = -118.045181274

BingKey = raw_input('Enter Your Bing API Key for Route and Geocode: Return to use default>')
if len(BingKey) == 0:
    BingKey = 'YourBingKey'
    
dbconnstr = 'dbname=' + dbname + ' host=' + dbhost + ' user=' + dbuser + ' password=' + dbpass

sql01 = 'select shiptoid,address,city,state,zip from customershipaddress '
sql01 += 'where (lat is null or long is null or changeflag=1) and customername <> \'NTC\' and shiptoid in '
sql01 += '(select distinct shiptoid from shipassignment where assignmentid=\'' + AssignID  + '\')'

#Connect the darabase for postal address
conn = psycopg2.connect(dbconnstr)
print 'Connected to Database'

cur = conn.cursor()
cur.execute(sql01)
rows = cur.fetchall()

rownum = cur.rowcount
print 'There are ' + str(rownum) + ' addresses needed to geocode'


#Only if Lat or Long is null or The address has been changed (detecting by changeflag), conduct geocode
#by Geocoding service from arcgis online
if rownum > 0:
    JSONGeoReq = ''
    for row in rows:       
        state = urllib.quote(row[3])
        city = urllib.quote(row[2])
        postal = urllib.quote(row[4])
        address = urllib.quote(row[1])
        JSONGeoReq = 'http://dev.virtualearth.net/REST/v1/Locations?countryRegion=US&adminDistrict='+state+'&locality='
        JSONGeoReq = JSONGeoReq+city+'&postalCode='+postal+'&addressLine='+address+'&key='+BingKey
        #print JSONGeoReq
        f = urllib2.urlopen(JSONGeoReq)
        JSONGeo = json.load(f)
        f.close()

        statusCode = JSONGeo['statusCode']
        if statusCode==200:
            RetCount = JSONGeo['resourceSets'][0]['estimatedTotal']
            if RetCount > 0:
                Lat = JSONGeo['resourceSets'][0]['resources'][0]['point']['coordinates'][0]
                Long = JSONGeo['resourceSets'][0]['resources'][0]['point']['coordinates'][1]
                #print str(Lat)
                #print str(Long)
                sql02 = 'update customershipaddress set lat=' + str(Lat) + ',long=' + str(Long) + ',changeflag=0 where shiptoid=\'' + str(row[0]) + '\';'
                cur.execute(sql02)
                conn.commit()
        #Some delay to avoid the error from bing web server. (You cannot request too many for the short period of time)        
        time.sleep(3)
        
#Now Load all Point Data order by distance from Warehouse (Use Post GIS Spatial Function)
wh_lat = 33.9125823975
wh_long = -118.045181274
distance_sql = ' order by ST_Length(GEOGRAPHY(ST_GeometryFromText(\'LINESTRING(' + str(wh_long) + ' ' + str(wh_lat)
distance_sql += ',\' || Long || \' \' || Lat || \')\',4326)))'

sql03 = 'select shiptoid,lat,long,address,city,state,zip,accountid,customername '
sql03 += 'from customershipaddress where lat is not null and long is not null and customername <> \'NTC\' and '
sql03 += 'shiptoid in (select distinct shiptoid from shipassignment where assignmentid=\'' + AssignID  + '\') '
sql03 += distance_sql
#print sql03

cur.execute(sql03)
rows = cur.fetchall()

rownum = cur.rowcount
print 'There are ' + str(rownum) + ' delivery customer locations for this delivery assigment:' + AssignID

#Now again, write the address information including xy into csv and also create the JSON string for route service request
csvf = open('ShipToAddr.csv', 'w')
csvf.write('ShipToID,Lat,Long,Address,City,State,Zip,AccountID,CustomerName\n')
csvf.write('90000,'+str(wh_lat)+','+str(wh_long)+',13409 Orden Drive,Santa Fe Springs,CA,90670,10000,NTC\n')

#JSONRtReq = 'http://dev.virtualearth.net/REST/v1/Routes?optimize=time&routePathOutput=Points&key='+BingKey+'&wp.0='+str(wh_lat)+','+str(wh_long)
JSONRtReq = 'http://dev.virtualearth.net/REST/v1/Routes?optimize=timeWithTraffic&routePathOutput=Points&key='+BingKey+'&wp.0='+str(wh_lat)+','+str(wh_long)

wpcnt = 1
if rownum > 0:
    print "Now loading the delivery address to CSV file"
    for row in rows:
        addrline = row[0]+','+str(row[1])+','+str(row[2])+','+row[3]+','+row[4]+','+row[5]+','+row[6]+','+row[7]+','+row[8]+'\n' 
        csvf.write(addrline)

        if (wpcnt % 7)!= 0:
            JSONRtReq += '&vwp.'+str(wpcnt)+'='+str(row[1])+','+str(row[2])
        else:
            JSONRtReq += '&wp.'+str(wpcnt)+'='+str(row[1])+','+str(row[2])
            
        wpcnt += 1
            
    JSONRtReq += '&wp.'+str(wpcnt)+'='+str(wh_lat)+','+str(wh_long)
        
csvf.close()
cur.close()
conn.close()

#print JSONRtReq
# Now Load the XY Data from CSV 
   
out_layer = "Delibery"
out_data = "C:\\EsriPress\\GIST1\\PythonPrimer\\Project\\FP\\Outputs.gdb\\Delibery"
 
# Set the spatial reference
spRef = "WGS 1984.prj"
 
# Make the XY event layer...
arcpy.MakeXYEventLayer_management('ShipToAddr.csv','Long','Lat', out_layer, spRef)
 
# Print the total rows
print arcpy.GetCount_management(out_layer)
 
# Save to a layer file
if arcpy.Exists(out_data):
        arcpy.Delete_management(out_data)
         
arcpy.CopyFeatures_management(out_layer, out_data)


#Now using Delivery Point data, we request arcgis online for the optimal route for delivery

f = urllib2.urlopen(JSONRtReq)
JSONRoute = json.load(f)
f.close()
node = JSONRoute['resourceSets'][0]['resources'][0]['routePath']['line']['coordinates']
distance = JSONRoute['resourceSets'][0]['resources'][0]['travelDistance']
drivetime = JSONRoute['resourceSets'][0]['resources'][0]['travelDuration']
#print str(node)

csvf = open('DeliveryRouteXY.csv', 'w')
csvf.write('Lat,Long\n')

for xy in node:
    xystr = str(xy).replace('[','').replace(']','').replace(' ','').split(',')
    print xystr[0] + ' and ' + xystr[1]
    csvf.write(xystr[0]+','+xystr[1]+'\n')
csvf.close()

#Also Stop Sequence information is saved into CSV, this will be joined table to the delivery to display the sequence on the map
#csvf = open('Stops.csv', 'w')
#csvf.write('ShipToID,Sequence\n')
#stops = JSONRoute['stops']['features']
#for stop in stops:
    #print str(stop['attributes']['Sequence']) + ',' + str(stop['attributes']['Name'])
#    csvf.write(str(stop['attributes']['Name']) + ',' + str(stop['attributes']['Sequence'])+'\n')
#csvf.close()

msgtxt = 'Drive Time for this delivery(Mins):' + str(drivetime) + '\n'
msgtxt = msgtxt + 'Drive Length for this delivery(Km):' + str(distance) + '\n'


#print msgtxt

#Now the route points set will be converted to the line feature
point_layer = "DeliberyRoutePoints"
point_data = "C:\\EsriPress\\GIST1\\PythonPrimer\\Project\\FP\\Outputs.gdb\\DeliberyRoutePoints"
 
# Set the spatial reference
spRef = "WGS 1984.prj"
 
# Make the XY event layer...
arcpy.MakeXYEventLayer_management('DeliveryRouteXY.csv','Long','Lat', point_layer, spRef)
 
# Print the total rows
print arcpy.GetCount_management(point_layer)
 
# Save to a layer file
if arcpy.Exists(point_data):
        arcpy.Delete_management(point_data)
        
arcpy.CopyFeatures_management(point_layer, point_data)

# Set local variables
line_data = "C:\\EsriPress\\GIST1\\PythonPrimer\\Project\\FP\\Outputs.gdb\\DeliberyRoute"

# Execute PointsToLine
if arcpy.Exists(line_data):
        arcpy.Delete_management(line_data)
arcpy.PointsToLine_management(point_data, line_data)

#Map Generation

mxd = MapDocument('BingBasemap.mxd')

# Report some of the Map Document Properties
mxd.title = 'Delivery Assignment:' + AssignID
dataframe = ListDataFrames(mxd, "Layers") [0]

mapExtent = dataframe.extent

TOCLayers = ListLayers(mxd) 

print 'Processing layout elements...'
tElements = ListLayoutElements(mxd, "TEXT_ELEMENT")
for tElement in tElements:
    if tElement.name == 'Delivery Time and Length':                
        tElement.text = msgtxt
    if tElement.name == 'Print Date':  
        tElement.text = str(CUR_DATE)

# Check to see if PDF exists, if it does, delete it
if arcpy.Exists(arcpy.env.workspace + 'test_map.pdf'):
    arcpy.Delete_management(arcpy.env.workspace + 'test_map.pdf')

print 'Writing PDF file...'

# Create the PDF document
ExportToPDF(mxd, AssignID + '_Bing_map.pdf')
print 'Created : ' + AssignID + '_map.pdf'

print 'Completed Map Updates'
