#SDE Database Maintenance
#
#Created by Justin Quesada(SASD)
#created on 3/12/2015
#updated on 5/1/2015
#Perform scheduled general maintenance on multiple SDE Databases


import arcpy, os, sys, traceback, time
#import modules.

arcpy.env.workspace = "Enter local pathway to ArcCatalog here"
#set specified work environment on administrators workstation.

sde1 = "databasename.sde" 
#sde2 = "databasename.sde"
#sde3 = "databasename.sde"
#sde4 = "databasename.sde"
#sde5 = "databasename.sde"
#set variable for each connection of the respective databases.
#It is important to note that these connections should
#have administrative privilege in order to run geodatabase adminitraiton tools.

path = arcpy.env.workspace

ws1 = os.path.join(path, sde1)
#ws2 = os.path.join(path, sde2)
#ws3 = os.path.join(path, sde3)
#ws4 = os.path.join(path, sde4)
#ws5 = os.path.join(path, sde5)
#build variables specific to each administrative connection.

workspacelist = [ws1] #,ws2,ws3,ws4,ws5
#populate list with ws variables.

try:
    
    for ws in workspacelist:
    #A for-loop is used to process each database in the workspacelist
        
        arcpy.env.workspace = ws
        #Set workspace environment to produce lists for input datasets.

        base = os.path.basename(ws)
        print "Begin Database maintenance for " + base
        #Create a variable to return the databasename.sde for the output log file
        
        timestr = time.strftime("%Y%m%d-%H%M%S")
        #Create a variable to display the date and time the maintenance was completed.
        #Source: http://stackoverflow.com/questions/10607688/how-to-create-a-file-name-with-the-current-date-time-in-python
        
        logFile = open("c:\\temp\\" + base + timestr + ".txt","w")
        #Create a log by opening a path and naming the file with the base and time variables.
        #Source: http://support.esri.com/en/knowledgebase/techarticles/detail/38445
        
        arcpy.DisconnectUser(ws, "ALL")
        print "All Users Disconnected"
        #Disconnect all users currently in the database.
        #This will be done late at night or during non-peak hours to minimize user impact.

        versions = arcpy.ListVersions(ws)
        #Create a list of existing versions to be Reconciled.

        arcpy.ReconcileVersions_management(ws, "All_VERSIONS", "SDE.DEFAULT", versions, "NO_LOCK_ACQUIRED", "NO_ABORT", "BY_OBJECT", "FAVOR_EDIT_VERSION", "NO_POST", "KEEP_VERSION")
        print "Versions Reconciled"
        #Reconcile all versions for the geodatabase. It is important to have no locks as they may interfere with the other processes.
        #The tool will not abort is conflicts are detected. They will instead be resolved in favor of the Default version.
        #Posts will not be made and versions will not be deleted. That is the responsibility of
        #the workflow administrator.
        #The Reconcile log option was not used. The logfile output will have the messages recorded.
        #Source: http://resources.arcgis.com/en/help/main/10.2/index.html#/Reconcile_Versions/00170000015p000000/
        
        logFile.write(arcpy.GetMessages())
        #The geoprocessing messages will be written to the logfile after each tool runs.

        arcpy.Compress_management(ws)
        print "Compress Complete"
        #Compress the database to remove states not referenced by a version and redundant data.
        #Remove clutter and improve integrity of the database.
        #Source: http://resources.arcgis.com/en/help/main/10.2/index.html#/Compress/00170000000p000000/
        logFile.write(arcpy.GetMessages())

        datalist = arcpy.ListTables() + arcpy.ListFeatureClasses()
        #Create a master dataset list of Feature Classes and Tables in the database.

        pathspace = arcpy.env.workspace
        #variable required for os.path.join. The environment variable will be changed in the dataset for-loop.

        for dataset in arcpy.ListDatasets("", "Feature"):
            arcpy.env.workspace = os.path.join(pathspace,dataset)
            datalist += arcpy.ListFeatureClasses() + arcpy.ListDatasets()
        #A for-loop is used to Make a direct connection to each Deataset that exists in the geodatabase.
        #Add every feature class found within each dataset of the ListDatasets to the master list.
        #http://resources.arcgis.com/en/help/main/10.2/index.html#/Rebuild_Indexes/00170000014w000000/
       
        arcpy.env.workspace = ws
        #Reset the workspace environment.
        
        arcpy.RebuildIndexes_management(ws, "SYSTEM", datalist, "ALL")
        print "Indexes Rebuilt"
        #Rebuild the indexes that are associated with the data in the datalist.
        #Indexes for the states and state lineages tables were changed by the reconcile and compress.
        #by assigning "SYSTEM", Those tables indexes will be rebuilt.
        #http://resources.arcgis.com/en/help/main/10.2/index.html#/Rebuild_Indexes/00170000014w000000/
        logFile.write(arcpy.GetMessages())

        arcpy.AnalyzeDatasets_management(ws, "SYSTEM", datalist, "ANALYZE_BASE", "ANALYZE_DELTA", "ANALYZE_ARCHIVE")
        print "Statistics have been updated"
        #Update statistics to optimize querying performance.
        #The "SYSTEM" parameter was selected because the states and state lineages tables have been modified.
        #Source: http://resources.arcgis.com/en/help/main/10.2/index.html#/Analyze_Datasets/00170000014z000000/
        logFile.write(arcpy.GetMessages())
        
        txtFile.close()
        #close the logfile 
        print "Mainenance Log Created."

        print "Maintenance Complete"
        #print statements are used as a validation of the program working.
       

except:

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
    #Error handling exception code to troubleshoot problems with the script.
    #Source: http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000



    
