#PMU NAIP IMAGERY PYTHON PROGRAM
#Created by Kim Mauch
#Created on: 05.05.2014
#Last updated on:05/15/2014 5:08 pm

#This script will identify NAIP imagery needed for a specific PMU, choose the year of imagery
#desired, and copy the imagery to a specified folder on the user's external or hard drive.

print 'PMU NAIP IMAGERY PYTHON PROGRAM'

#Import required modules
import arcpy, os, sys, traceback

#Define workspace
arcpy.env.workspace = 'N:\\PMU_NAIP\\'

#VARIABLES
#The input choices are the PMU names (one only); USER INPUT REQUIRED.
PMUname = "Majuba_1_2"
print "The PMU you have selected is " + PMUname

#The input choices are limited to 2010, 2011, 2013; USER INPUT REQUIRED.
imagery_yr = str(2013)
print "The year of imagery you have selected is " + imagery_yr

#The input choices are limited to CA, ID, NV & OR; USER INPUT REQUIRED.
imagery_state = "NV"
print "The state you have selected is  " + imagery_state

#identify location of NAIP imagery; USER INPUT REQUIRED.
input_path = 'N:\\2013NevadaNAIP\\201307_nevada_naip_1x0000m_utm_cnir\\'
print "NAIP input file path is " + input_path

#Create a variable for the output folder
foldername = PMUname + "NAIP" + imagery_yr + imagery_state

#Define the output path for the output folder; USER INPUT REQUIRED.
output_path = 'C:\\Nevada_Conifer\\' + foldername + "\\"''
print "The output file path you have specified is " + output_path

#Define the file path to the NAIP index
NAIP_Index_fc = 'N:\\PMU_NAIP\\ProjectWide_noUCD_BG_editCopy21.shp'

#Define NAIP_Index feature layer
NAIP_Index_fl = "Index"



try:
    if arcpy.Exists(NAIP_Index_fl):
        arcpy.Delete_management(NAIP_Index_fl)

#Make feature layer of NAIP Index
    arcpy.MakeFeatureLayer_management(NAIP_Index_fc, NAIP_Index_fl)
    print "Making NAIP Index feature layer..."

#Create new folder for NAIP imagery on specified output path
    os.mkdir(output_path)
    print "Creating new output folder for " + PMUname + " NAIP imagery..."
    print "The folder name is: " +  foldername

#Define variables for search cursor
    pmu_field = "PMU"
    filepath_field = "FilePath"
    filename_field = "Filename2"
    query = """PMU = '""" + PMUname + """'"""
    print query
    print "Now locating files..."
    counter = 1
	#Use search cursor to locate specific PMU NAIP imagery files from index
    with arcpy.da.SearchCursor(NAIP_Index_fc, (pmu_field, filepath_field, filename_field), where_clause=query) as srows:
        for srow in srows:
            pmu = srow[0]
            filepath = srow[1]
            filename = srow[2]
            print "PMU is  " + srow[0] + "; " + "File name is "  + srow[2]
            counter += 1
            arcpy.CopyRaster_management(filepath, output_path + filename, "", "", "", "None", "None", "", "None", "None")
        print 'Located and Copied ' + str(counter - 1) +' NAIP files for ' + PMUname
    print 'Process Complete!'

    del srow, srows

except:

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
