import arcpy, sqlite3, os, re, sys

class ToolValidator(object):
  """Class for validating a tool's parameter values and controlling
  the behavior of the tool's dialog."""

  def __init__(self):
    """Setup arcpy and the list of tool parameters."""
    self.params = arcpy.GetParameterInfo()

  def initializeParameters(self):
    """Setup arcpy and the list of tool parameters."""
    return

  def updateParameters(self):    
    somelist = self.params[8].filter

    # if the 'Search' Button is clicked...
    if self.params[7].altered:
        # if data is entered in to the first 'Path' field
	if self.params[1].altered:
          
                #set the second 'Path' field to the string value of the first
		self.params[2].value = str(self.params[1].value)
	      
	#Setup the connection to the database file and clear variables
    	con = sqlite3.connect(r"D:\ GeoFileDatabase\geofiles2.db")
    	con.text_factory = str
    	cur = con.cursor()
	query = 'SELECT * '
	whereClause = ''
	FieldList = ''
	param_fileID = arcpy.GetParameterAsText(0)
	arcpy.CopyParameter(1, 8)

        # if data is entered into the 'Search' Fields, build the SQL SELECT statement and the WHERE clause
    	if param_fileID == '':
		if self.params[0].value > 0:
			FieldList = 'FileID'
			whereClause = whereClause + "FileID like '" + self.params[0].value + "' "

    	if self.params[2].value:
		if FieldList == '':
			FieldList = 'Path'
			whereClause = whereClause + "path like '" + self.params[2].value + "%' "
		else:
			FieldList = FieldList + ', Path'
			whereClause = whereClause + "AND path like '" + self.params[2].value + "%' "

    	if self.params[3].value:
		if FieldList == '':
			FieldList = 'Name'
			whereClause = whereClause + "name like '%" + self.params[3].value + "%' "
		else:
			FieldList = FieldList + ', Name'
			whereClause = whereClause + "AND name like '%" + self.params[3].value + "%' "

    	if self.params[4].value:
		if FieldList == '':
			FieldList = 'FileType'
			whereClause = whereClause + "FileType like '%" + self.params[4].value + "%' "
		else:
			FieldList = FieldList + ', FileType'
			whereClause = whereClause + "AND FileType like '%" + self.params[4].value + "%' "

    	if self.params[5].value:
		if FieldList == '':
			FieldList = 'Description'
			whereClause = whereClause + "Description like '%" + self.params[5].value + "%' "
		else:
			FieldList = FieldList + ', Description'
			whereClause = whereClause + "AND Description like '%" + self.params[5].value + "%' "

    	if self.params[6].value:
		if FieldList == '':
			FieldList = 'Keywords'
			whereClause = whereClause + "Keywords like '%" + self.params[6].value + "%' "
		else:
			FieldList = FieldList + ', Keywords'
			whereClause = whereClause + "AND Keywords like '%" + self.params[6].value + "%' "
			
        # Finish the text for the query statement
        query = query + ' FROM datafiles where ' + whereClause

        # Perform query
        cur.execute(query)

        # Create a list from the data returned
        result_list = [str(row[0]) + '    ' + row[1] + row[2] for row in cur.fetchall()]
	somelist.list = result_list
       	con.commit()

       	# Close the connection to the database file
        con.close()

        # Set Action checkboxes to be unchecked
	self.params[7].value = ''
	self.params[9].value = ''

    # if one of the files from the search is chosen for the list...
    if self.params[8].altered:

        # Get the ID of the chosen record
	Get_ID = str(self.params[8].value)

	# Connect to the database again
    	con = sqlite3.connect(r"D:\ GeoFileDatabase\geofiles2.db")
    	con.text_factory = str
    	cur = con.cursor()

    	# Create query for chosen record
	query = 'SELECT * '
	whereClause = 'FileID = ' + Get_ID[1:Get_ID.find(' ')]
	query = query + ' FROM datafiles where ' + whereClause

	# Execute query for the chosen record
       	cur.execute(query)

	result_list = cur.fetchone()

        # Set fields in the Toolbox to fields data from database
	self.params[10].value = result_list[0]
	self.params[11].value = result_list[1]
	self.params[12].value = result_list[2]
	self.params[13].value = result_list[3]
	self.params[14].value = result_list[4]
	self.params[15].value = result_list[5]

        con.commit()

        # Close database connection
        con.close()

    # if the user wants to add the chosen file to the current document...
    if self.params[16].altered:

        # Form the path to the file from the database field data
	File_path = self.params[11].value + self.params[12].value
	self.params[17].value = File_path

	# Add file to the current document
	arcpy.MakeFeatureLayer_management(File_path, self.params[12].value)
    return

  def updateMessages(self):
    """Modify the messages created by internal validation for each tool
    parameter.  This method is called after internal validation."""

    return
