# Geog 375 Final Project
# Created by: Kathryn Gross
# Created on: 05.14.2014
# Updated on: 05.15.2014

print 'KGross Final Project: Evaluating species range accuracy'

import arcpy, sys, os, traceback

# Set the current workspace
arcpy.env.workspace = 'G:\\GEOG_375\\PythonPrimer\\Chapter06\\MyData\\Python_final\\'

# Create variables
ERURE_pts = "ERURE_pts.shp"
Jepson_Ecoregions = "Jepson_Ecoregions.shp"

ERURE_fl = "ERURE FL"
Ecoregions_fl = "Ecoregions FL"


try:

    # Add range field to shapefile of species observation points
    arcpy.AddField_management(ERURE_pts, "In_Range", "TEXT", "", "", "1", "", "NULLABLE", "NON_REQUIRED", "")

    print 'Added In_Range field to species observation layer'

    # Make a feature layer from the species observation points
    arcpy.MakeFeatureLayer_management(ERURE_pts, ERURE_fl)

    urows = arcpy.UpdateCursor(ERURE_pts)

    # Create ecoregion query
    query = "\"SUBREGION\" = 'KR'"

    # Make a feature layer from the ecoregion feature class, including specific ecoregion query
    arcpy.MakeFeatureLayer_management(Jepson_Ecoregions, Ecoregions_fl, query)

    # Select species observation points that occur within the selected ecoregion
    arcpy.SelectLayerByLocation_management(ERURE_fl, "WITHIN", Ecoregions_fl, "", "NEW_SELECTION")

    print 'Selected points that fall within given range'

    for urow in urows:

        # Populate all In_Range fields with a default value of "N" for "No"
        urow.In_Range = "N"
        urows.updateRow(urow)
        
        srows = arcpy.SearchCursor(ERURE_fl)
        
        for srow in srows:
            # For points that have been selected as the feature layer, selecting on unique ID of OCCNUMBER,
            # update In_Range value to "Y" for "Yes"
            if urow.OCCNUMBER == srow.OCCNUMBER:
                urow.In_Range = "Y"
                urows.updateRow(urow)

    print 'In_Range field updated, completed range analysis'




except:

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
