# Created by:  Lance Duncan
# Created on: 05.12.2014
# Updated on: 05.15.2014

'''
This project demonstrates what I have learned from this course in python
programming. I will be making use of searh cursors, selectiing by location,
zooming to location, and editing map layout elements.
'''

print 'Project script begin \n'

import arcpy, sys, os, traceback, datetime
from arcpy.mapping import *

#set workspace
arcpy.env.workspace = 'C:\\Users\\lance\\Documents\\ArcGIS\\geog375\\project\\Project.gdb'
#arcpy.env.workspace = 'E:\\geog375\\project\\Project.gdb'

#variables
CNTY = 'Counties' #source county feature class
CNTY_L = 'Counties_fl' #feature layer of county feature class
HOS = 'Hospitals' # source feature class with hospital locations
HOS_L = 'Hospitals_fl' #feature layer of hospitals
H_C = 'Hospital_join_County'
H_C_L = 'Hospital_County_Layer'
map_path = 'C:\\Users\\lance\\Documents\\ArcGIS\\geog375\\project\\'
mxd = MapDocument(map_path + 'Project.mxd')
TODAY = datetime.date.today().strftime('%m.%d.%Y')
author = 'Lance Duncan'
df = ListDataFrames(mxd, "Layers") [0]
sac = map_path + 'sac.mxd'

try:
#1-join hospitals with counties
    #create indexes, first deleting any previuosly made
    indexes = arcpy.ListIndexes(CNTY)
    for index in indexes:
        if(index.name == 'cnty_index'):
            arcpy.RemoveIndex_management(CNTY, 'cnty_index')
    indexes = arcpy.ListIndexes(HOS)
    for index in indexes:
        if(index.name == 'hos_index'):
            arcpy.RemoveIndex_management(HOS, 'hos_index')
    arcpy.AddIndex_management(CNTY, 'NAME; STATE_NAME; FIPS', 'cnty_index', 'NON_UNIQUE', 'NON_ASCENDING')
    print 'index created for ' + CNTY
    arcpy.AddIndex_management(HOS, 'NAME; STCTYFIPS; ELEV_METER', 'hos_index', 'NON_UNIQUE', 'NON_ASCENDING')
    print 'index created for ' + HOS
    #create feature layers, first deleting any previuosly made
    if arcpy.Exists(CNTY_L):
        arcpy.Delete_management(CNTY_L)
    if arcpy.Exists(HOS_L):
        arcpy.Delete_management(HOS_L)
    arcpy.MakeFeatureLayer_management(CNTY, CNTY_L)
    print 'feature layer created for ' + CNTY
    arcpy.MakeFeatureLayer_management(HOS, HOS_L)
    print 'feature layer created for ' + HOS
    #execute join
    arcpy.AddJoin_management(HOS_L, "STCTYFIPS", CNTY_L, "FIPS", "KEEP_ALL")
    print 'joined ' + CNTY_L + ' and ' + HOS_L
    #print field names of join to ensure proper completion
    fields = arcpy.ListFields(HOS_L)
    print 'resulting fields: \n'
    for field in fields:
        print field.name
#2-create new feature class from join
    if arcpy.Exists(H_C):
        arcpy.Delete_management(H_C)        
    arcpy.CopyFeatures_management(HOS_L, H_C)
    print '\n New feature class created from join'
    #remove join to free up memory
    arcpy.RemoveJoin_management(HOS_L, CNTY)
    print 'join removed'
#3-query new feature class
    #make feature layer for the new feature class
    if arcpy.Exists(H_C_L):
        arcpy.Delete_management(H_C_L)
    arcpy.MakeFeatureLayer_management(H_C, H_C_L)
    print 'feature layer created for ' + H_C
    #define a query
    query = """"Counties_NAME"= 'Sacramento'"""
    #execute selection
    print 'searching for features...'
    arcpy.SelectLayerByAttribute_management(H_C_L, "NEW_SELECTION", query)
    result = arcpy.GetCount_management(H_C_L)
    print 'number of hospitals found: ' + str(result)
#4-use search cursor to uncover names of selected features
    print 'names of hospitals found: \n'
    with arcpy.da.SearchCursor(H_C, "Hospitals_NAME", where_clause=query) as srows:
        for srow in srows:
            hos_name = srow[0]

            print hos_name
#5-add feature class to map 
    hospitals = arcpy.mapping.Layer(H_C_L)
    arcpy.mapping.AddLayer(df, hospitals, "AUTO_ARRANGE")
    print '\n added ' + H_C_L + ' to map document'
#6-modify map layout and dataframe
    #access layers
    TOCs = ListLayers(mxd, '', df)
    print 'layers within map document: \n' 
    for TOC in TOCs:
        print str(TOC.name)     #print layers to confirm desired result
        if TOC.name == 'Hospital_County_Layer':     #Label selected hospitals
            TOC.showLabels = True
    print '\n' + H_C_L + ' features labeled'
    #zoom to selected features
    df.zoomToSelectedFeatures()
    df.scale = df.scale * 1.5
    print 'zoomed to selection'
    #update layout elements
    Texts = ListLayoutElements(mxd, "TEXT_ELEMENT")
    for Text in Texts:
        if Text.name == 'Title':
            Text.text = 'Sacramento, CA'
        if Text.name == 'Date':
            Text.text = str(TODAY)
            Text.elementPositionX = 0.6
        if Text.name == 'Author':
            Text.text = author
            Text.elementPositionX = 0.6
            print 'updated Title, Date, and Author'
#7-export map, first deleting any previuosly made
    if arcpy.Exists(sac):
        arcpy.Delete_management(sac)
    mxd.saveACopy(sac)
    print 'exported to ' + sac
    
    print 'writing PDF to file...'
    if arcpy.Exists(map_path + 'sac.pdf'):
        arcpy.Delete_management(map_path + 'sac.pdf')
    ExportToPDF(mxd, map_path + 'sac.pdf')
    print 'created pdf of map'
      
    print '\n script complete'
    

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000
    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
    
    
