# Final Project ECS - Summary Statistics - Sum population and average area based on query

# Elyse Cheung-Sutton
# 5/13/2014
# GEOG 375
# Purpose:
# For the CalEnviroscreen project, people often want to know various statistics for whatever
# variable they are interested in (i.e. how many people live in the Top 10%). This program
# is meant to be run as a scripting tool in ArcGIS so that there is a GUI for the Parameters.

import arcpy

arcpy.env.workspace = 'C:\\Users\\cheunge\\Desktop\\Python\\FinalProject\\CES.gdb'

inputfile = arcpy.GetParameterAsText(0) #only allow user to choose CES ZIPs or CT
inputfile_layer = 'Input Layer'
outputfile = arcpy.GetParameterAsText(1) #name of summary statistics table, must be .dbf
outputtemp = 'SelectedFeatures'
query = arcpy.GetParameterAsText(2)

#try: (except block was getting an error so commented both out)

#Check if the output file exists
if arcpy.Exists(outputfile):
    arcpy.Delete_management(outputfile)
arcpy.AddMessage('Selecting features from ' + inputfile)

#Check if the layer for the input file exists
if arcpy.Exists(inputfile_layer):
    arcpy.Delete_management(inputfile_layer)

#Make layer and select attributes based on query parameter
arcpy.MakeFeatureLayer_management(inputfile, inputfile_layer)
arcpy.SelectLayerByAttribute_management(inputfile_layer, "NEW_SELECTION", query)
   
#Print the number of selected features based on the query              
result = arcpy.GetCount_management(inputfile_layer)
print 'Number of selected tracts = ' + str(result)
arcpy.AddMessage('Number of selected tracts = ' + str(result))

#Create a temporary file for the selected features
arcpy.CopyRows_management(inputfile_layer, outputtemp) 

#Create Summary Statistics table
#Edit the third parameter below to include more statistics if desired
arcpy.Statistics_analysis(outputtemp, outputfile, [["pop2010", "SUM"],["CI10grps", "MEAN"]])

#Delete temporary output file
if arcpy.Exists(outputtemp):
    arcpy.Delete_management(outputtemp)

arcpy.AddMessage('Finished exporting Summary Statistics Table.')

#except:

    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    #tb = sys.exc_info()[2]
    #tbinfo = traceback.format_tb(tb)[0]
    #pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    #msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # prints error messages in the Progress dialog box
    #arcpy.AddError(msgs)   
    #arcpy.AddError(pymsg)

    # prints messages to the Python Shell
    #print msgs
    #print pymsg

    #arcpy.AddMessage(arcpy.GetMessages(1))

    #print arcpy.GetMessages(1)
