# Final Project ECS - Creating a PDF of Map Display based on bookmarks

# Elyse Cheung-Sutton
# 5/13/2014
# GEOG 375
# Purpose:
#For the CalEnviroscreen (CES) project, people often want to see different results, comparisons, etc in various
#locations across CA. If done manually, this task requires much clicking and manual editing.
#This program will create PDF screenshots based on a set of bookmarks.

###Make sure to set up mxd before beginning!!!
###Items that must be set up in mxd:
    #Layers (visibility, transparency, symbology etc)
    #Bookmarks
    #Anchor point of data frame (at bottom left)
    #Legend
    #Map Title called "Map Title"
    #Date called "Print Date"

#Workspace

import arcpy, sys, os, string, traceback, datetime
from arcpy.mapping import *

arcpy.env.workspace = 'C:\\Users\\cheunge\\Desktop\\Python\\FinalProject\\'

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')

try: 
    
    #Set path and variables
    outpath = 'C:\\Users\\cheunge\\Desktop\\Python\\FinalProject\\'
    outPDFpath = outpath + 'PDFs\\'
    outdatapath = outpath + 'Output.gdb\\'

    # Access mxd

    mxd = MapDocument('CES_Screenshots.mxd')

    # Print mxd info

    print 'Map Document Title: ' + str(mxd.title)
    print 'Map Document Author: ' + str(mxd.author)

    #Access Layers in Table of Contents
    
    TOCLayers = ListLayers(mxd)
    
    # Print which layers are on and their transparency   
    for TOCLayer in TOCLayers:
        if TOCLayer.name == 'Reference' or TOCLayer.name == 'Light Gray Canvas Base':
            #Transparency is not supported on Basemap layers
            print 'Layer: ' + str(TOCLayer.name) + ' transparency NA.'
            
        else:
            if TOCLayer.visible == False:
                layervis = 'OFF'
            
            else:
                layervis = 'ON'
            transp = TOCLayer.transparency
            print 'Layer: ' + str(TOCLayer.name) + ' is ' + layervis + ' and transparency is ' + str(transp)
       
    #Ask user if desired layers are on... 
        startover = raw_input('Are all the desired layers on at correct transparency? Type YES or NO: ')
        if startover == 'NO':
            print 'Please exit Python and make desired changes in ArcMap.'
                
        elif startover == 'YES':
            print 'Beginning PDF Process...'

            # Create list of bookmarks and loop

            bkmks = ListBookmarks(mxd)
            df = ListDataFrames(mxd, "Layers") [0]

            # Set data frame to line up exactly with page size
            # Not necessary if done in prep
            #df.elementPositionX = 0
            #df.elementPositionY = 0

            # Page Setup
            # Here I want to set the data frame size to equal the page size
            # :( apparently I can't do this http://forums.arcgis.com/threads/80231-Python-Map-Page-Size

            #Ask user for naming convention

            filename = raw_input ('Please enter a name for file naming purposes (i.e CES2.0Tracts_)(Location will be added to name automatically): ')
            
            # Set data frame extent as bookmark extent
            for bkmk in bkmks:
                bkmkname = bkmk.name
                print bkmkname
                df.extent = bkmk.extent
                
                # Edit Map Title and Date
                tElements = ListLayoutElements(mxd, "TEXT_ELEMENT")
                
                for tElement in tElements:
                    if tElement.name == 'Map Title':
                        tElement.text = 'CalEnviroscreen Results in ' + bkmkname

                    if tElement.name == 'Print Date': 
                        tElement.text = str(CUR_DATE) 

                    ### Remove items in legend if turned off in TOC
                    ### Not necessary if done in prep
                    # Seems like the only way to add item to legend is with autoAdd property which requires adding layer

                    #legend = ListLayoutElements(mxd, "LEGEND_ELEMENT") [0]
                    #for TOCLayer in TOCLayers:
                        #if TOCLayer.visibility == False:
                            #legend.removeItem(TOCLayer)

                # Export to pdf for each bookmark
                outPDF = outPDFpath + filename + bkmkname + '.pdf'
                ExportToPDF(mxd, outPDF)
            
### To do another time: set resolution and file type of export
    
        #Else statement if user types raw_input incorrectly. Program must be restarted.    
        else:
            print 'Input entered incorrectly. Please restart program and type YES or NO when prompted.'

except:

    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # prints error messages in the Progress dialog box
    arcpy.AddError(msgs)   
    arcpy.AddError(pymsg)

    # prints messages to the Python Shell
    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))

    print arcpy.GetMessages(1)   
