# Final Project ECS - Selecting CES Results based on Input File

# 5/13/2014
# GEOG 375
#Purpose: 
#The CalEnviroscreen (CES) project often gets data requests asking to see the CES results for a particular area.
#This program will create a feature class, database table, and Excel spreadsheet based on an input polygon file
#of the study area and which CES Results (ZIP 1.1 or Census Tract 2.0) the user would like to see.

# Workspace

import arcpy, sys, os, string, traceback

arcpy.env.workspace = 'C:\\Users\\cheunge\\Desktop\\Python\\FinalProject\\CES.gdb'

outpath = 'C:\\Users\\cheunge\\Desktop\\Python\\FinalProject\\Output.gdb'

# Variables (let user choose ZIP or CT results?)

CES_tracts = 'CES2_0results_wrace'
CES_tracts_layer = 'CES_tracts_lyr'
CES_ZIPs = 'ZCTA_norace_ces1_1demo_dec'
CES_ZIPs_layer = 'CES_ZIPs_lyr'

try:

# Create feature class based on study area and CES results

    #User will choose CES file
    print 'Choose which CES results to analyze.'
    ZIPorCT = raw_input('Type ZIP (for CES 1.1 ZIP Results) or CT (for CES 2.0 Census Tract Results): ')

    #Selectionfile based on User's input
    
    if ZIPorCT <> 'ZIP' and ZIPorCT <> 'CT':
        print 'Input entered incorrectly. Please restart program and type ZIP or CT to choose which CES results to analyze.'
    
    else:
        if ZIPorCT == 'ZIP':
            selectionfile = CES_ZIPs
            selectionfile_layer = CES_ZIPs_layer
        
        else:
            selectionfile = CES_tracts
            selectionfile_layer = CES_tracts_layer
        
        if arcpy.Exists(selectionfile_layer):
            arcpy.Delete_management(selectionfile_layer)

        # Ask for input file to use in intersect
        # so many problems with this...!!!
        # I'm not sure if the user will be able to input their file properly
        # because shapefiles and feature classes are multiple files... GAH
        input_file = sys.argv[1]
        inputfile_layer = 'Input Layer'
        
        if arcpy.Exists(inputfile_layer):
            arcpy.Delete_management(inputfile_layer)
        
        #input_file = arcpy.GetParameterAsText(0)
        input_name = raw_input('Please enter the name of the study area for file naming purposes: ')

        outfilename = outpath + os.sep + input_name + '_CES_' + ZIPorCT

        # Select by location and copy features
        
        arcpy.MakeFeatureLayer_management(selectionfile, selectionfile_layer)
        arcpy.MakeFeatureLayer_management(inputfile, inputfile_layer)
        arcpy.SelectLayerByLocation_management(selectionfile_layer, "INTERSECT", inputfile_layer)
    
        result = arcpy.GetCount_management(selectionfile_layer)
        print 'Number of selected tracts = ' + str(result)
        
        arcpy.CopyFeatures_management(selectionfile_layer, outfilename)
    
# Create table from above feature class

        output_dbtable = outfilename + '.dbf'
        output_Excel = 'C:\\Users\\cheunge\\Desktop\\Python\\FinalProject\\' + input_name + '_CES_' + ZIPorCT + '.xls'
    
        arcpy.CopyRows_management(selectionfile_layer, output_dbtable) 

# Create Excel file from above dbf

        arcpy.TableToExcel_conversion(output_dbtable, output_Excel)
    
        print 'Finished creating feature class, dbf, and xls :D'

except:

    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # prints error messages in the Progress dialog box
    arcpy.AddError(msgs)   
    arcpy.AddError(pymsg)

    # prints messages to the Python Shell
    print msgs
    print pymsg

    arcpy.AddMessage(arcpy.GetMessages(1))

    print arcpy.GetMessages(1)   
