# Final Project
# Created by: Sean Carroll
# Created on: May 2015
# SeanC2926@hotmail.com
# Create maps of individual MSSA based on demographic attributes




import arcpy, sys, traceback, datetime
from arcpy.mapping import *   


# Set workpath
arcpy.env.workspace = "J:\\Python_Final\\MSSA\\"

MSSA = "MSSA_2010ACSv2.shp"

MSSALayer = "MSSALayer"


author = 'Sean_Carroll'  

# Add current date

CUR_DATE = datetime.date.today().strftime('%m.%d.%Y')


try:


    # print the number of records in the feature class
    result = arcpy.GetCount_management(MSSA) 
    print "Number of features in the feature class " + MSSA + " : " + str(result)

    # check to see if the feature layer exists; if so, delete it
    if arcpy.Exists(MSSALayer):
        arcpy.Delete_management(MSSALayer)

    # make the feature layer
    arcpy.MakeFeatureLayer_management(MSSA, MSSALayer)
  

    # check to see if the feature layer exists; if so, delete it
    if arcpy.Exists(MSSALayer):
        arcpy.Delete_management(MSSALayer)

    # create a feature layer using a query
    # ENTER ANY SEARCH QUERIES HERE TO MAKE CUSTOMIZED MAP SETS
    # BASED ON NEED

    query = """"PCT_ASIAN" > 50 AND "PCT_65OVER" > 10"""

    # make the feature layer using the query parameter
    arcpy.MakeFeatureLayer_management(MSSA, MSSALayer, query)

    # print the number of records in the feature layer with query
    result = arcpy.GetCount_management(MSSALayer) 
    print "Number of features in the feature layer " + MSSALayer + " with a query: "+ str(result)

# Set data paths and get the map template
   
    datapath = 'j:\\Python_Final\\'
    mappath = datapath + '\\Maps\\'
    mxd = MapDocument(datapath + 'Final_Template.mxd')

    # Get a list of data frames

    dataframe = ListDataFrames(mxd, "Layers") [0]

    
    # Get a list of layers in the table of contents of the map document
    TOCLayers = ListLayers(mxd) 

    # loop through the layers
    for TOCLayer in TOCLayers:
        print 'Layer Name ' + str(TOCLayer.name)
        
        print 'Longname ' + str(TOCLayer.longName)  

        if TOCLayer.longName == 'MSSA_Detail\MSSA':
            print 'inside TOC'
            MSSALayer = TOCLayer     
    
    

    #   Create a search cursor on the MSSALayer

    field_name = ["MSSA_ID"]
    with arcpy.da.SearchCursor(MSSALayer, field_name) as MSSArows:
    


        #   Create a for loop to loop through the individual rows
        #   of the MSSA Layer.


        for MSSArow in MSSArows:
            
        
            #  Set a variable to the MSSA's MSSA_ID field
            
            MSSAName = MSSArow[0]  
            #  Create a query variable to that uses the MSSA ID variable
            
            
            query1 = """"MSSA_ID" = '""" + MSSAName + """'"""

            #  Assign the MSSA Layer's definitionQuery property to the query variable
              

            TOCLayer.definitionQuery = query1

            #  Set the data frame's extent property to to the layer's extent 

            dataframe.extent = TOCLayer.getExtent()

            dataframe.scale = dataframe.scale * 1.1        

            #  Create a list variable of the layout elements that are "text" elements.

            tElements = ListLayoutElements(mxd, "TEXT_ELEMENT")

            #  Within the loop over the search cursor rows, create another
            #  for loop over the text elements
            #  Here I changed the variable elements in the layout for each map

            for tElement in tElements:


                if tElement.name == 'MSSA ID':
                    tElement.text = "MSSA" + " " + MSSAName
                    tElement.elementPositionX = 8.9
                    

                if tElement.name == 'Author':
                    tElement.text = author
                    tElement.elementPositionX = 1.1



                if tElement.name == 'Print Date':
                    tElement.text = str(CUR_DATE)
                    tElement.elementPositionX = 1.1262



            #  Check to see if maps are created already, if they are delete them


            if arcpy.Exists(mappath + MSSAName + "_map.PDF"):
                arcpy.Delete_management(mappath + MSSAName + "_map.PDF")



            #  Export the individual maps to PDF

            
            ExportToPDF(mxd, mappath + MSSAName + "_map.PDF")

            print 'Map' + ' ' + MSSAName + ' ' + 'Was Created'


            
    del mxd

    print 'Completed Unique Map Sheets'

except:
    # http://help.arcgis.com/en/arcgisdesktop/10.0/help/index.html#//002z0000000q000000

    
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)


    
