# Python script attached to the 'Revocable Plans Update' tool
# City of Sacramento, Public Works-DE Revocable Scans Attribute Updates

# Created by: Juanita Cano 
# Updated on: 4.22.14
# Sources:  City of Sacramento, 
# Jennings, Nathan. A Python Primer for ArcGIS. 2011
# Most Codes/script created by Nathan Jennings and modified as need to adopt to
# Revocable Permit Updates Tool


'''
A single selected record at a time filled in with the following attributes.
'''

# Exception class to flag if an error occurs within the try statement, an exception
# is raised, and the code under the except statement is then executed.  This will return
# a python error message for use in script tool.


# 1. Used to handle less than or more than one selected feature
# and to prevent more than one feature from being updated
# 2. You must enter something if Misc is entered as a keyword.
# 3. For missing keywords, if a keyword is not selected


class NotOneSelection(Exception):
    pass

class NoMisc(Exception):
    pass

class NoKeywords(Exception):
    pass

import arcpy, sys, os, traceback, arcgisscripting, types


# User Provided inputs.  Gets the parameter values for the script tool
# in ArcGIS. Defined with order to enter into tool.

flayer = arcpy.GetParameterAsText(0) # selected feature layer
revocable_plan_num = arcpy.GetParameterAsText(1) # plan number
plan_title  = arcpy.GetParameterAsText(2) # plan title
approval_date  = arcpy.GetParameterAsText(3) # approval date
exist_key  = arcpy.GetParameterAsText(4) # a list of keywords
keywords  = arcpy.GetParameterAsText(5) # keywords to select from
misc_key  = arcpy.GetParameterAsText(6) # miscelaneous keyword
image_location = arcpy.GetParameterAsText(7) # file path for image
comments = arcpy.GetParameterAsText(8) # comments


arcpy.AddMessage("Updating Revocable Plans...")

arcpy.AddMessage("keywords are: " + keywords)
key_list = []
arcpy.AddMessage("keylen of empty list is: " + str(len(key_list)))

key_list = keywords.split(';')
arcpy.AddMessage("keylen of split list is: " + str(len(key_list)))
for key_val in key_list:
    arcpy.AddMessage("THE KEY VAL IS: ..." + str(key_val) + "...")

#misc_list = misc_key.split(',')
keylen = 0

try:

    keylen = len(key_list)
    arcpy.AddMessage("keylen is: " + str(keylen))

    # a split list has a length of 1, even if there are no "elements" in the list
    if keylen == 1 and key_list[0] == "" and exist_key == "":
        arcpy.AddMessage("keylist is empty")
        raise NoKeywords

    
    for key_val in key_list:
        arcpy.AddMessage(key_val)
        if key_val == 'MISCELLANEOUS' and misc_key == "":
            raise NoMisc



    '''
    mcnt = 0
    for misc_val in misc_list:
        mcnt +=1
        arcpy.AddMessage(misc_val)
        if mcnt == 1:
            misc_string = 'MISC ' + "(" + misc_key + "), "
            arcpy.AddMessage("misc string: " + misc_string)
        elif mcnt < len(misc_list):
            misc_string = misc_string + 'MISCELLANEOUS' + "(" + str(misc_val) + "), "
            arcpy.AddMessage("else if misc string: " + misc_string)
        else:
            misc_string = misc_string + 'MISCELLANEOUS' + "(" + str(misc_val)+ ")"
            arcpy.AddMessage("else misc string: " + misc_string)
        
        arcpy.AddMessage(misc_string)
    '''
    #kl = ",".join(key_list)
    cnt = 0

    # compute keyword string
    for keyval in key_list:
        cnt += 1
        arcpy.AddMessage("keyword is: " + keyval)
        
        if cnt == 1:
            if keyval == 'MISCELLANEOUS':
                keystring = 'MISC (' + misc_key + ')'
                arcpy.AddMessage("keystring misc: " + keystring)
            else:
                keystring = str(keyval)
                arcpy.AddMessage("keystring: " + keystring)
        elif cnt < keylen:
            if cnt == 2:
                if keyval == 'MISCELLANEOUS':
                    keystring = keystring + ", MISC (" + misc_key + "), "
                    arcpy.AddMessage("else if mkeystring cnt = 2: " + keystring)
                else:
                    keystring = keystring + ", " + str(keyval) + ", "
                    arcpy.AddMessage("else if keystring cnt = 2: " + keystring)
                
            elif keyval == 'MISCELLANEOUS':
                keystring = keystring + "MISC (" + misc_key + "), "
                arcpy.AddMessage("else if mkeystring: " + keystring)
            else:
                keystring = keystring + str(keyval) + ", "
                arcpy.AddMessage("else if keystring: " + keystring)

        else:
            if cnt == 2:
                if keyval == 'MISCELLANEOUS':
                    keystring = keystring + ", MISC (" + misc_key + ")"
                    arcpy.AddMessage("else mkeystring cnt = 2: " + keystring)
                else:
                    keystring = keystring + ", " + str(keyval)
                    arcpy.AddMessage("else keystring cnt = 2: " + keystring)
                    
            elif keyval == 'MISCELLANEOUS':
                keystring = keystring + "MISC (" + misc_key + ")"
                arcpy.AddMessage("else mkeystring: " + keystring)
            else:
                keystring = keystring + str(keyval)
                arcpy.AddMessage("else keystring: " + keystring)


#try:

    # should only be one record.
    # Get the count of selected records.
    #If no selected records the result returns a count of all records

    result = int(arcpy.GetCount_management(flayer).getOutput(0))

    #arcpy.AddMessage("result is: " + str(result))

    # Error check to see if only one record is selected, if not the script throws an error
    # see NotOneSelection error class above

    if result <> 1:
        arcpy.AddMessage("Number of Selected Features: " + str(result) + '\nOnly one feature can be selected')
        raise NotOneSelection(result)
        
    # Update the record with any new information from the script tool
    urows = arcpy.UpdateCursor(flayer)

    for urow in urows:
        
        urow.Permit_No = revocable_plan_num.upper()
        urow.Plan_Title = plan_title.upper()
        urow.Aprov_Date = approval_date
        urow.ImageLoc = image_location


        if urow.Keywords == "":   # if there is no existing value for Type (i.e. when a new feature is added)
            urow.Keywords = keystring.replace("'","").upper()
        else:
            if keylen == 1 and keyval == "":
                urow.Keywords = exist_key.upper()  # populate Type with existing value; no new keywords to add
            else:
                urow.Keywords = keystring.replace("'","").upper() # replace existing with new list of key words
                
        
            
        arcpy.AddMessage("Updating comments") 
        urow.Comment = comments.upper()
       

        urows.updateRow(urow)
       
    del urow, urows
    arcpy.AddMessage("Updated Selected feature\n")

#Error Handling

except NoMisc:
    arcpy.AddError("Cannot have a blank Miscellaneous keyword.\nEnter one or more miscellaneous keywords.")

except NoKeywords:
    arcpy.AddError("At least one keyword must be chosen.\nEnter one or more keywords.")

except NotOneSelection:
    arcpy.AddError("Only one feature can be selected")




        
except:

    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]
    pymsg = "PYTHON ERRORS:\nTraceback Info:\n" + tbinfo + "\nError Info:\n     " +        str(sys.exc_type) + ": " + str(sys.exc_value) + "\n"
    msgs = "ARCPY ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    arcpy.AddError(msgs)
    arcpy.AddError(pymsg)

    print msgs
    print pymsg
    
    arcpy.AddMessage(arcpy.GetMessages(1))
    print arcpy.GetMessages(1)
